/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV4;
import com.excentis.products.byteblower.run.actions.natdiscovery.IPV6;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;
import com.excentis.products.byteblower.run.actions.natdiscovery.VLAN;
import com.excentis.products.byteblower.run.objects.RuntimePort;

public class LinkPath {
    private EndPoint src;
    private EndPoint dest;

    private LinkPath(RuntimePort srcPort, RuntimePort destPort, NatDiscovery.L4Protocol proto, int srcL4Port, int destL4Port) {
        this.src = EndPoint.create(srcPort, proto, srcL4Port);
        this.dest = EndPoint.create(destPort, proto, destL4Port);
    }

    public LinkPath(RuntimePort srcPort, RuntimePort destPort, FrameReader baseFrame, Direction dir) {
        this.src = EndPoint.create(srcPort, baseFrame, dir);
        this.dest = EndPoint.create(destPort, baseFrame, dir.reverse());
    }

    LinkPath(LinkPath origLink) {
        this.src = origLink.src.deepCopy();
        this.dest = origLink.dest.deepCopy();
    }

    public static LinkPath fromHTTP(RuntimePort server, RuntimePort client, int srcPort, int destPort) {
        return new LinkPath(server, client, NatDiscovery.L4Protocol.TCP, srcPort, destPort);
    }

    public NatDiscovery.L4Protocol protocol() {
        return this.src.getProtocol();
    }

    public String getSource() {
        return this.src.getSource();
    }

    public int getPort() {
        return this.src.getPort();
    }

    public int hashCode() {
        return this.dest.hashCode() + this.src.hashCode();
    }

    public boolean equals(Object oth) {
        return oth != null && oth instanceof LinkPath && this.equals((LinkPath)oth);
    }

    public boolean equals(LinkPath oth) {
        return oth != null && this.dest.equals(oth.dest) && this.src.equals(oth.src);
    }

    protected EndPoint getDestinationEnd() {
        return this.dest;
    }

    protected EndPoint getSourceEnd() {
        return this.src;
    }

    public static class FilterVisitor
    implements EndPoint.EndVisitor {
        protected String filter = "";

        private void addFilter(String exp) {
            if (!this.filter.isEmpty()) {
                this.filter = String.valueOf(this.filter) + " && ";
            }
            this.filter = String.valueOf(this.filter) + exp;
        }

        @Override
        public void call(VLAN v) {
            for (short id : v) {
                this.addFilter("vlan " + id);
            }
        }

        @Override
        public void call(IPV4 i) {
            this.addFilter("ip dst " + i.getSource());
        }

        @Override
        public void call(UDP u) {
            this.addFilter("udp dst port " + u.getPort());
        }

        @Override
        public void call(TCP t) {
            this.addFilter("tcp dst port " + t.getPort());
        }

        @Override
        public void call(IPV6 i) {
            this.addFilter("ip6 dst " + i.getSource());
        }
    }
}

