/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.PortForwardingReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.DumbCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkPath;
import com.excentis.products.byteblower.run.actions.natdiscovery.LinkProbe;
import com.excentis.products.byteblower.run.actions.natdiscovery.NATCache;
import com.excentis.products.byteblower.run.actions.natdiscovery.PortMapDestination;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.HashMap;
import java.util.Map;

public class ManualIPPortForward
implements NATCache {
    private DumbCache cache = new DumbCache();
    private Map<PortMapDestination, Integer> portMappings = new HashMap<PortMapDestination, Integer>();
    private String publicAddress;

    public ManualIPPortForward(PortForwardingReader forwardReader) {
        this.publicAddress = forwardReader.getManualPublicIpv4AddressString();
        for (PortMapping map : forwardReader.getPortMappings()) {
            PortMapDestination privateMap = new PortMapDestination(map.getProtocol().name(), (int)map.getPrivatePort());
            this.portMappings.put(privateMap, map.getPublicPort());
        }
    }

    private boolean localResolution(LinkPath path) {
        PortMapDestination toSearch = new PortMapDestination(path.protocol(), path.getPort());
        return this.portMappings.containsKey(toSearch);
    }

    @Override
    public boolean isResolved(LinkPath path) {
        return this.localResolution(path) || this.cache.isResolved(path);
    }

    @Override
    public LinkPath result(LinkPath path) {
        LinkPath result;
        if (this.localResolution(path)) {
            PortMapDestination toSearch = new PortMapDestination(path.protocol(), path.getPort());
            int port = this.portMappings.get(toSearch);
            LinkPath oth = new LinkPath(path);
            EndPoint src = oth.getSourceEnd();
            src.setIP4Address(this.publicAddress);
            src.setPort(port);
            result = oth;
        } else {
            result = this.cache.result(path);
        }
        return result;
    }

    @Override
    public LinkProbe createProbe(LinkPath path, RuntimePort src, RuntimePort dest, FrameReader base) {
        return this.cache.createProbe(path, src, dest, base);
    }

    @Override
    public String createFilter(LinkPath path) {
        return this.cache.createFilter(path);
    }

    @Override
    public boolean resolve(LinkPath origLink, LinkProbe probe, byte[] probeResult) {
        return this.cache.resolve(origLink, probe, probeResult);
    }

    @Override
    public NatDiscovery.NatDiscoveryParameters parameters(LinkPath origLink) {
        if (this.localResolution(origLink)) {
            return new NatDiscovery.NatDiscoveryParameters(NatDiscovery.IpType.MANUAL_PUBLIC_IP, NatDiscovery.PortType.MANUAL_PUBLIC_PORT, null);
        }
        return this.cache.parameters(origLink);
    }
}

