/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.actions.natdiscovery;

import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.NatDiscovery;
import com.excentis.products.byteblower.run.actions.natdiscovery.Direction;
import com.excentis.products.byteblower.run.actions.natdiscovery.EndPoint;
import com.excentis.products.byteblower.run.actions.natdiscovery.TCP;
import com.excentis.products.byteblower.run.actions.natdiscovery.UDP;

abstract class TransportLayer {
    TransportLayer() {
    }

    static TransportLayer createFromIPV4(FrameReader frame, Direction dir) {
        Ipv4Packet ipv4 = frame.getIpv4();
        int protocol = ipv4.getProtocol();
        if (17 == protocol) {
            return new UDP(frame.getCurrentUdp(), dir);
        }
        if (6 == protocol) {
            return new TCP(frame.getCurrentTcp(), dir);
        }
        throw new IllegalStateException("NAT Discovery only for UDP and TCP packets");
    }

    static TransportLayer createFromIPV6(FrameReader frame, Direction dir) {
        Ipv6Packet ipv6 = frame.getIpv6();
        int protocol = ipv6.getNextHeader();
        if (17 == protocol) {
            return new UDP(frame.getCurrentUdp(), dir);
        }
        if (6 == protocol) {
            return new TCP(frame.getCurrentTcp(), dir);
        }
        throw new IllegalStateException("NAT Discovery only for UDP and TCP packets");
    }

    public static TransportLayer create(NatDiscovery.L4Protocol probeProtocol, int port) {
        if (NatDiscovery.L4Protocol.TCP == probeProtocol) {
            return new TCP(port);
        }
        if (NatDiscovery.L4Protocol.UDP == probeProtocol) {
            return new UDP(port);
        }
        throw new IllegalStateException("NAT Discovery only for UDP and TCP packets");
    }

    public abstract boolean equals(Object var1);

    public abstract void setPort(int var1);

    public abstract void visit(EndPoint.EndVisitor var1);

    public abstract int getPort();

    public abstract NatDiscovery.L4Protocol getProtocol();

    public abstract TransportLayer deepCopy();

    public abstract int hashCode();
}

