/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.filters;

import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;

public final class PortNumberFilter
extends BPFFilter {
    private int port;

    public static PortNumberFilter createUDPSourcePortFilter(int port) {
        return new PortNumberFilter(BPFFilter.Proto.UDP, BPFFilter.Dir.SRC, port);
    }

    public static PortNumberFilter createUDPDestinationPortFilter(int port) {
        return new PortNumberFilter(BPFFilter.Proto.UDP, BPFFilter.Dir.DST, port);
    }

    public static PortNumberFilter createTCPSourcePortFilter(int port) {
        return new PortNumberFilter(BPFFilter.Proto.TCP, BPFFilter.Dir.SRC, port);
    }

    public static PortNumberFilter createTCPDestinationPortFilter(int port) {
        return new PortNumberFilter(BPFFilter.Proto.TCP, BPFFilter.Dir.DST, port);
    }

    private PortNumberFilter(BPFFilter.Proto protocol, BPFFilter.Dir direction, int port) {
        super(protocol, direction);
        this.port = port;
    }

    public String toString() {
        return String.format("%s %s port %d", this.getProtocol().toString(), this.getDirection().toString(), this.port);
    }

    @Override
    protected boolean excludesBPFFilterImpl(Filter filter) {
        if (filter instanceof PortNumberFilter) {
            PortNumberFilter rhs = (PortNumberFilter)filter;
            return this.port != rhs.port;
        }
        return false;
    }
}

