/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.HTTPClient;
import com.excentis.products.byteblower.communication.api.HTTPServer;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.objects.RuntimeBBHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.HashMap;
import java.util.Map;

class PortHTTPConfig {
    private final Map<TcpFlow, RuntimeHttpServer> httpServers = new HashMap<TcpFlow, RuntimeHttpServer>();
    private final Map<RuntimeHttpFlow, RuntimeHttpClient> httpClients = new HashMap<RuntimeHttpFlow, RuntimeHttpClient>();
    private final RuntimePort bbPort;

    public PortHTTPConfig(RuntimePort parentPort) {
        this.bbPort = parentPort;
    }

    public RuntimeHttpClient addRuntimeHttpClient(HTTPClient apiHttpClient, RuntimeHttpFlow rtHttpFlow) {
        if (this.hasRuntimeHttpClient(rtHttpFlow)) {
            throw new IllegalStateException("RuntimeHttpClient was already created for flow " + rtHttpFlow.name());
        }
        RuntimeBBHttpClient rtHttpClient = new RuntimeBBHttpClient(this.bbPort, apiHttpClient, rtHttpFlow);
        this.httpClients.put(rtHttpFlow, rtHttpClient);
        return rtHttpClient;
    }

    private boolean hasRuntimeHttpClient(RuntimeHttpFlow rtHttpFlow) {
        return this.httpClients.containsKey(rtHttpFlow);
    }

    public RuntimeHttpServer addRuntimeHttpServer(HTTPServer apiHttpServer, TcpFlow mHttpFlowTemplate) {
        if (this.hasRuntimeHttpServer(mHttpFlowTemplate)) {
            throw new IllegalStateException("RuntimeHttpServer was already created for flow template " + mHttpFlowTemplate.getName());
        }
        RuntimeHttpServer rtHttpServer = new RuntimeHttpServer(this.bbPort, apiHttpServer, mHttpFlowTemplate);
        this.httpServers.put(mHttpFlowTemplate, rtHttpServer);
        return rtHttpServer;
    }

    private boolean hasRuntimeHttpServer(TcpFlow mHttpFlowTemplate) {
        return this.findRuntimeHttpServer(mHttpFlowTemplate) != null;
    }

    public RuntimeHttpServer findRuntimeHttpServer(TcpFlow mHttpFlowTemplate) {
        RuntimeHttpServer rtHttpServer1 = this.httpServers.get(mHttpFlowTemplate);
        if (rtHttpServer1 != null) {
            return rtHttpServer1;
        }
        TcpFlowReader tcpFlowReader1 = ReaderFactory.create((TcpFlow)mHttpFlowTemplate);
        for (RuntimeHttpServer rtHttpServer2 : this.httpServers.values()) {
            TcpFlowReader tcpFlowReader2 = rtHttpServer2.getModelHttpFlowTemplateReader();
            if (!this.compareTcpServerSettings(tcpFlowReader1, tcpFlowReader2)) continue;
            return rtHttpServer2;
        }
        return null;
    }

    private boolean compareTcpServerSettings(TcpFlowReader tcpFlowReader1, TcpFlowReader tcpFlowReader2) {
        boolean autoServerPort2;
        boolean result = true;
        boolean autoServerPort1 = tcpFlowReader1.hasAutomaticServerPort();
        if (autoServerPort1 != (autoServerPort2 = tcpFlowReader2.hasAutomaticServerPort())) {
            result = false;
        } else if (!autoServerPort1) {
            Integer serverPortNumber1 = tcpFlowReader1.getServerPortNumber();
            Integer serverPortNumber2 = tcpFlowReader2.getServerPortNumber();
            result &= serverPortNumber2 == serverPortNumber1 || serverPortNumber1 != null && serverPortNumber1.equals(serverPortNumber2);
        }
        result &= tcpFlowReader1.getTCPCongestionAvoidanceAlgorithm() == tcpFlowReader2.getTCPCongestionAvoidanceAlgorithm();
        result &= tcpFlowReader1.getSlowStartThreshold() == tcpFlowReader2.getSlowStartThreshold();
        Integer rcvWindowSize1 = tcpFlowReader1.getInitialReceiveWindowSizeNumber();
        Integer rcvWindowSize2 = tcpFlowReader2.getInitialReceiveWindowSizeNumber();
        result &= rcvWindowSize1 == rcvWindowSize2 || rcvWindowSize1 != null && rcvWindowSize1.equals(rcvWindowSize2);
        result &= tcpFlowReader1.usesReceiveWindowScaling() == tcpFlowReader2.usesReceiveWindowScaling();
        if (tcpFlowReader1.usesReceiveWindowScaling()) {
            result &= tcpFlowReader1.getRcvWindowScale() == tcpFlowReader2.getRcvWindowScale();
        }
        return result &= tcpFlowReader1.isL4S() == tcpFlowReader2.isL4S();
    }
}

