/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects.RFC2544;

import com.excentis.products.byteblower.communication.api.TriggerBasic;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultData;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultDataList;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultHistory;
import com.excentis.products.byteblower.run.objects.RFC2544.TestResult;
import com.excentis.products.byteblower.run.objects.RFC2544.TriggerAlgo;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeTriggerBasic;
import java.util.ArrayList;

public class BBTriggerAlgo
implements TriggerAlgo {
    private final RuntimePort dest;
    private final String filter;
    private TriggerBasic trigger;

    public BBTriggerAlgo(RuntimePort dest, RuntimeFrameRx rx) {
        this.dest = dest;
        ArrayList<RuntimeFrameRx> frames = new ArrayList<RuntimeFrameRx>();
        frames.add(rx);
        this.trigger = dest.getApiPort().RxTriggerBasicAdd();
        RuntimeTriggerBasic rtRx = new RuntimeTriggerBasic(frames, dest, this.trigger);
        this.cleanup();
        this.filter = rtRx.getFilter().toString();
    }

    @Override
    public void start() {
        this.trigger = this.dest.getApiPort().RxTriggerBasicAdd();
        this.trigger.FilterSet(this.filter);
    }

    @Override
    public TestResult calcResult(long ifg, long packetSize, long txPackets, long txBytes) {
        long durationNanosecond = 1L;
        long rxBytes = 0L;
        long rxPackets = 0L;
        TriggerBasicResultHistory rxHistory = this.trigger.ResultHistoryGet();
        rxHistory.Refresh();
        TriggerBasicResultDataList rxCumul = rxHistory.CumulativeGet();
        if (rxCumul.size() > 0) {
            TriggerBasicResultData rxSnap = rxCumul.get(rxCumul.size() - 1);
            rxPackets = rxSnap.PacketCountGet();
            rxBytes = rxSnap.ByteCountGet();
            if (rxPackets > 1L) {
                durationNanosecond = rxSnap.TimestampLastGet() - rxSnap.TimestampFirstGet();
            }
        }
        return new TestResult(ifg, txBytes, rxBytes, durationNanosecond, txPackets, rxPackets, packetSize);
    }

    @Override
    public void cleanup() {
        if (this.trigger != null) {
            this.dest.getApiPort().RxTriggerBasicRemove(this.trigger);
            this.trigger = null;
        }
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

