/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.communication.api.ByteBlowerInterface;
import com.excentis.products.byteblower.communication.api.ByteBlowerPortList;
import com.excentis.products.byteblower.communication.api.ByteBlowerServer;
import com.excentis.products.byteblower.communication.api.PhysicalInterface;
import com.excentis.products.byteblower.run.objects.RuntimeByteBlower;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeServer;
import com.excentis.products.byteblower.run.utils.DebugInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RuntimeBBServer
extends RuntimeServer {
    private final ByteBlowerServer apiServer;
    private final Map<String, RuntimeInterface> interfaces;

    protected RuntimeBBServer(RuntimeByteBlower rtByteBlower, ByteBlowerServer apiServer) {
        super(rtByteBlower);
        this.apiServer = apiServer;
        this.interfaces = new HashMap<String, RuntimeInterface>();
        for (PhysicalInterface netInterface : apiServer.PhysicalInterfacesGet()) {
            for (ByteBlowerInterface bbInterface : netInterface.ByteBlowerInterfaceGet()) {
                String id = bbInterface.NameGet();
                this.interfaces.put(id, new RuntimeInterface(this, id));
            }
        }
    }

    public ByteBlowerServer getApiServer() {
        return this.apiServer;
    }

    public Collection<RuntimeInterface> interfaces() {
        return this.interfaces.values();
    }

    @Override
    public String getName() {
        return this.apiServer.ServiceInfoGet().ConnectionHostGet();
    }

    @Override
    public String getIPAddress() {
        return this.apiServer.ServiceInfoGet().ConnectionIPAddressGet();
    }

    @Override
    public String getDescription() {
        return this.apiServer.DescriptionGet();
    }

    @Override
    public String getVersion() {
        return this.apiServer.ServiceInfoGet().VersionGet();
    }

    @Override
    public String getType() {
        return this.apiServer.ServiceInfoGet().SeriesGet();
    }

    @Override
    public void cleanup(ByteBlower apiByteblower) {
        apiByteblower.ServerRemove(this.apiServer);
    }

    @Override
    public long now() {
        return this.apiServer.TimestampGet();
    }

    @Override
    public long startAll(Collection<RuntimePort> endpoints) {
        ByteBlowerPortList apiPortList = new ByteBlowerPortList();
        endpoints.forEach(port -> {
            boolean bl = apiPortList.add(port.getApiPort());
        });
        this.apiServer.PortsStart(apiPortList);
        return 0L;
    }

    @Override
    public String getUUID() {
        return this.apiServer.ServiceInfoGet().ServiceIDGet();
    }

    public RuntimeInterface getRuntimeInterface(String physicalInterfaceString) {
        return this.interfaces.get(physicalInterfaceString);
    }

    @Override
    protected Collection<? extends DebugInfo> collectDebugInfo() {
        ArrayList<DebugInfo> info = new ArrayList<DebugInfo>();
        for (RuntimeInterface bbInterface : this.interfaces.values()) {
            info.addAll(bbInterface.collectDebugInfo());
        }
        return info;
    }
}

