/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.DeviceStatus;
import com.excentis.products.byteblower.communication.api.FrameTagTx;
import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.communication.api.StreamResultData;
import com.excentis.products.byteblower.communication.api.StreamResultHistory;
import com.excentis.products.byteblower.communication.api.StreamResultList;
import com.excentis.products.byteblower.communication.api.StreamRuntimeStatus;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.LatencyAndJitterType;
import com.excentis.products.byteblower.model.OutOfSequenceType;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameSizeModifier;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimeGrowingSizeModifier;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimeRandomSizeModifier;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeTimingModifier;
import com.excentis.products.byteblower.run.utils.DeadlineTimer;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeFbFlow
extends RuntimeFlow {
    private static Long unique = 1L;
    private final FrameBlastingFlow mFbFlowTemplate;
    private final FrameBlastingFlowReader mFbFlowTemplateReader;
    private boolean allowLatency = true;
    private boolean allowOutOfOrder = true;
    private int divisor = 1;
    private List<RuntimeFrameTx> rtFramesTx = new ArrayList<RuntimeFrameTx>();
    private StreamMobile apiStreamMobile;
    private Stream apiStream;
    private RuntimeTimingModifier rtTimingModifier = null;
    private RuntimeFrameSizeModifier rtFrameModifier = null;
    private final DeadlineTimer deadline;
    private AddressableDestination destination = null;
    private final LatencyAndJitterType latencyType;
    private final OutOfSequenceType oosType;
    private boolean streamHasFinishedAlready = false;
    private long streamEnd = 0L;
    private boolean isMobile = false;
    private final List<RuntimeRx> triggers = new ArrayList<RuntimeRx>();

    protected RuntimeFbFlow(RuntimeScenario scenario, FlowMeasurement mFlowInstance) {
        super(scenario, mFlowInstance, RuntimeFlow.Type.FB);
        this.mFbFlowTemplate = (FrameBlastingFlow)mFlowInstance.getFlow().getFlowTemplate();
        this.mFbFlowTemplateReader = ReaderFactory.create((FrameBlastingFlow)this.mFbFlowTemplate);
        this.latencyType = mFlowInstance.getFlow().getLatencyAndJitterType();
        this.oosType = mFlowInstance.getFlow().getOutOfSequenceDetection();
        long flowDuration = 1000000000L + (long)(1.1 * (double)this.getEnd());
        this.deadline = new DeadlineTimer(flowDuration, TimeUnit.NANOSECONDS);
    }

    public RuntimeFbFlow(RuntimeScenario scenario, FlowMeasurement mFlowInstance, ByteBlowerGuiPort port) {
        super(scenario, mFlowInstance, RuntimeFlow.Type.FB);
        this.destination = port;
        this.mFbFlowTemplate = (FrameBlastingFlow)mFlowInstance.getFlow().getFlowTemplate();
        this.mFbFlowTemplateReader = ReaderFactory.create((FrameBlastingFlow)this.mFbFlowTemplate);
        this.latencyType = mFlowInstance.getFlow().getLatencyAndJitterType();
        this.oosType = mFlowInstance.getFlow().getOutOfSequenceDetection();
        long flowDuration = 1000000000L + (long)(1.1 * (double)this.getEnd());
        this.deadline = new DeadlineTimer(flowDuration, TimeUnit.NANOSECONDS);
    }

    @Override
    public long getEnd() {
        Long endTime = this.getModelFlowInstanceReader().getStopTimeInNanoseconds();
        if (endTime == null) {
            return Long.MAX_VALUE;
        }
        endTime = endTime + this.getRuntimeScenario().getRuntimeScenarioRunner().getRuntimePreferences().getWaitTimeAfterScenarioNs();
        return endTime;
    }

    public static void reInitialize() {
        unique = 1L;
    }

    public static long getUnique() {
        Long l = unique;
        unique = l + 1L;
        return l;
    }

    public void setDivisor(int div) {
        this.divisor = div;
    }

    public int getDivisor() {
        return this.divisor;
    }

    @Override
    protected AddressableDestination getDestination() {
        if (this.destination != null) {
            return this.destination;
        }
        return super.getDestination();
    }

    public void allowOutOfOrder(boolean isAllowed) {
        this.allowOutOfOrder = isAllowed;
    }

    public FrameBlastingFlow getModelFbFlowTemplate() {
        return this.mFbFlowTemplate;
    }

    public FrameBlastingFlowReader getModelFbFlowTemplateReader() {
        return this.mFbFlowTemplateReader;
    }

    public List<RuntimeFrameTx> getRuntimeFramesTx() {
        return this.rtFramesTx;
    }

    public RuntimeFrameTx getRuntimeFrameTx(Frame mFbFrame) {
        for (RuntimeFrameTx rtFrame : this.rtFramesTx) {
            if (rtFrame.getModelFbFrame() != mFbFrame) continue;
            return rtFrame;
        }
        return null;
    }

    public RuntimeFrameTx getRuntimeFrameTx(FrameReader mFrameReader) {
        Frame frame = (Frame)mFrameReader.getObject();
        return this.getRuntimeFrameTx(frame);
    }

    public void addRuntimeFrameTx(RuntimeFrameTx rtFrameTx) {
        this.rtFramesTx.add(rtFrameTx);
    }

    public Stream getApiStream() {
        return this.apiStream;
    }

    public void setApiStream(StreamMobile apiStream) {
        this.apiStreamMobile = apiStream;
    }

    public StreamMobile getApiStreamMobile() {
        return this.apiStreamMobile;
    }

    public void setApiStream(Stream apiStream) {
        if (apiStream == null) {
            throw new IllegalArgumentException("Cannot configure null stream on a FB flow");
        }
        if (this.apiStream != null) {
            throw new IllegalStateException("Cannot configure stream on a FB flow more than once");
        }
        apiStream.ResultHistoryGet();
        this.apiStream = apiStream;
    }

    public void addRuntimeReceiver(RuntimeRx rtRx) {
        this.triggers.add(rtRx);
    }

    public RuntimeTimingModifier setRuntimeTimingModifier(RuntimeTimingModifier rtTimingModifier) {
        if (this.rtTimingModifier != null) {
            throw new IllegalStateException("rtTimingModifier of flow should not be set twice");
        }
        this.rtTimingModifier = rtTimingModifier;
        return rtTimingModifier;
    }

    @Override
    public boolean isRuntimeFrameModifierConfigured() {
        return this.rtFrameModifier != null;
    }

    public boolean hasRuntimeFrameSizeModifier() {
        return this.isRuntimeFrameModifierGrowingSize() || this.isRuntimeFrameModifierRandomSize();
    }

    public boolean isRuntimeFrameModifierGrowingSize() {
        return this.rtFrameModifier instanceof RuntimeGrowingSizeModifier;
    }

    public boolean isRuntimeFrameModifierRandomSize() {
        return this.rtFrameModifier instanceof RuntimeRandomSizeModifier;
    }

    public RuntimeFrameSizeModifier getFrameModifier() {
        return this.rtFrameModifier;
    }

    public RuntimeFrameSizeModifier setRuntimeFrameModifier(RuntimeFrameSizeModifier rtFrameModifier) {
        if (this.rtFrameModifier != null) {
            throw new IllegalStateException("rtFrameModifier of flow should not be set twice");
        }
        this.rtFrameModifier = rtFrameModifier;
        return rtFrameModifier;
    }

    @Override
    public boolean hasOutOfSequenceDetection() {
        return this.allowOutOfOrder && this.oosType == OutOfSequenceType.YES;
    }

    @Override
    public boolean hasLatencyMeasurement() {
        return this.allowLatency && this.latencyType != LatencyAndJitterType.NO;
    }

    public boolean hasLatencyDistributionMeasurement() {
        return this.allowLatency && this.latencyType == LatencyAndJitterType.DISTRIBUTION;
    }

    public void setFrameTagTx(FrameTagTx tag) {
        this.isMobile = true;
    }

    public FrameTagTx getApiTimeTagTx() {
        if (this.isMobile) {
            return null;
        }
        if (!this.hasLatencyMeasurement()) {
            return null;
        }
        if (this.apiStream == null || this.apiStream.FrameGet().size() == 0) {
            throw new IllegalStateException("Should not retrieve API TimeTagTx before frames were added to stream");
        }
        return this.apiStream.FrameGet().get(0).FrameTagTimeGet();
    }

    public FrameTagTx getApiSequenceTagTx() {
        if (!this.hasOutOfSequenceDetection()) {
            return null;
        }
        if (this.apiStream == null || this.apiStream.FrameGet().size() == 0) {
            throw new IllegalStateException("Should not retrieve API TimeTagTx before frames were added to stream");
        }
        return this.apiStream.FrameGet().get(0).FrameTagSequenceGet();
    }

    private StreamRuntimeStatus getRuntimeStatus() {
        StreamRuntimeStatus runtimeStatus = this.apiStream.StatusGet();
        return runtimeStatus;
    }

    public StreamRuntimeStatus.transmit_error_status getErrorStatus() {
        if (this.apiStream == null) {
            return StreamRuntimeStatus.transmit_error_status.NONE;
        }
        StreamRuntimeStatus runtimeStatus = this.getRuntimeStatus();
        return runtimeStatus.ErrorStatusGet();
    }

    public StreamRuntimeStatus.transmit_error_source getErrorSource() {
        if (this.apiStream == null) {
            return StreamRuntimeStatus.transmit_error_source.NONE;
        }
        StreamRuntimeStatus runtimeStatus = this.getRuntimeStatus();
        return runtimeStatus.ErrorSourceGet();
    }

    public boolean hasTxErrorCode() {
        return this.getErrorStatus() != StreamRuntimeStatus.transmit_error_status.NONE;
    }

    public boolean hasTxOutOfResourcesErrorCode() {
        return this.getErrorStatus() == StreamRuntimeStatus.transmit_error_status.OUT_OF_RESOURCES;
    }

    public boolean hasTxOtherErrorCode() {
        return this.getErrorStatus() == StreamRuntimeStatus.transmit_error_status.UNKNOWN;
    }

    public List<FrameTagTx> getFrameTags() {
        FrameTagTx tag;
        ArrayList<FrameTagTx> tags = new ArrayList<FrameTagTx>();
        if (this.hasLatencyMeasurement() && (tag = this.getApiTimeTagTx()) != null) {
            tags.add(this.getApiTimeTagTx());
        }
        if (this.hasOutOfSequenceDetection()) {
            tags.add(this.getApiSequenceTagTx());
        }
        return tags;
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
        this.deadline.start();
        Stream stream = this.getApiStream();
        if (stream != null) {
            stream.ResultHistoryGet().Clear();
            toRefresh.add(new AbstractRefreshableResult[]{stream.ResultHistoryGet()});
            toRefresh.add(new AbstractRefreshableResult[]{stream.StatusGet()});
        }
        if (this.apiStreamMobile != null) {
            StreamResultHistory hist = this.apiStreamMobile.ResultHistoryGet();
            hist.Clear();
            toRefresh.add(new AbstractRefreshableResult[]{hist});
        }
        for (RuntimeRx rx : this.triggers) {
            rx.gatherRealtimeResults(toRefresh);
        }
    }

    private boolean finishedStreaming() {
        if (this.getApiStream() == null && this.getApiStreamMobile() != null) {
            RuntimeMobileDevice dev = (RuntimeMobileDevice)this.getSourceRuntimePort();
            DeviceStatus status = dev.getMobilePort().StatusGet();
            return !DeviceStatus.Running.equals(status) && !DeviceStatus.Starting.equals(status);
        }
        StreamRuntimeStatus status = this.getRuntimeStatus();
        return status.StatusGet().equals(StreamRuntimeStatus.transmit_status.INACTIVE);
    }

    @Override
    public boolean isDone() {
        long leadoutNs = this.getRuntimeScenario().getRuntimeScenarioRunner().getRuntimePreferences().getWaitTimeAfterScenarioNs();
        long leadoutMs = TimeUnit.NANOSECONDS.toMillis(leadoutNs);
        if (this.deadline.hasTimeout()) {
            Logger.getGlobal().log(Level.INFO, "Deadline has timed out");
            return true;
        }
        if (!this.streamHasFinishedAlready && this.finishedStreaming()) {
            this.streamEnd = System.currentTimeMillis();
            this.streamHasFinishedAlready = true;
        }
        if (this.streamHasFinishedAlready && this.streamEnd + leadoutMs < System.currentTimeMillis()) {
            boolean isFinished = true;
            for (RuntimeRx rx : this.triggers) {
                boolean bl = isFinished = isFinished && rx.isFinished();
            }
            return isFinished;
        }
        return false;
    }

    @Override
    public void updateFilters() {
        for (RuntimeRx rtRx : this.triggers) {
            rtRx.updateFilter();
        }
    }

    @Override
    public void resetResults() {
        for (RuntimeRx rx : this.triggers) {
            rx.resetResults();
        }
    }

    public void visitTriggers(RuntimeRx.TriggerVisitor visitor) {
        for (RuntimeRx rx : this.triggers) {
            rx.visit(visitor);
        }
    }

    public void visitSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        for (RuntimeRx rx : this.triggers) {
            rx.visit(visitor);
        }
    }

    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        for (RuntimeRx rx : this.triggers) {
            rx.visitCumulativeSnapshots(visitor);
        }
    }

    public LocalTriggerResultData txCumulativeSnapshot() {
        StreamResultHistory history = this.apiStream != null ? this.apiStream.ResultHistoryGet() : this.apiStreamMobile.ResultHistoryGet();
        StreamResultList cumulativeSnaps = history.CumulativeGet();
        if (cumulativeSnaps.size() > 0) {
            return new LocalTriggerResultData(cumulativeSnaps.get(cumulativeSnaps.size() - 1));
        }
        return new LocalTriggerResultData();
    }

    public List<LocalTriggerResultData> txIntervalSnapshots() {
        boolean beforeStreamStart;
        StreamResultHistory hist;
        if (this.getApiStream() != null) {
            hist = this.getApiStream().ResultHistoryGet();
        } else if (this.apiStreamMobile != null) {
            hist = this.apiStreamMobile.ResultHistoryGet();
        } else {
            return Collections.emptyList();
        }
        ArrayList<LocalTriggerResultData> intervalHistory = new ArrayList<LocalTriggerResultData>();
        for (StreamResultData a2 : hist.IntervalGet()) {
            intervalHistory.add(new LocalTriggerResultData(a2));
        }
        boolean hasData = intervalHistory.stream().filter(a -> a.PacketCountGet() > 0L).findAny().isPresent();
        boolean bl = beforeStreamStart = this.txCumulativeSnapshot().PacketCountGet() == 0L && !hasData;
        if (beforeStreamStart) {
            return Collections.emptyList();
        }
        if (intervalHistory.size() > 0) {
            intervalHistory.remove(intervalHistory.size() - 1);
        }
        return intervalHistory;
    }

    public boolean isValid() {
        return this.apiStream != null || this.apiStreamMobile != null;
    }
}

