/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.model.BenchmarkFrame;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingBenchmark;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.FrameBlastingBenchmarkReader;
import com.excentis.products.byteblower.model.reader.FrameReader;
import com.excentis.products.byteblower.run.actions.CreateFrame;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.exceptions.RuntimeDomainError;
import com.excentis.products.byteblower.run.objects.RFC2544.BBStreamAlgo;
import com.excentis.products.byteblower.run.objects.RFC2544.BBTriggerAlgo;
import com.excentis.products.byteblower.run.objects.RFC2544.MobileStreamAlgo;
import com.excentis.products.byteblower.run.objects.RFC2544.MobileTriggerAlgo;
import com.excentis.products.byteblower.run.objects.RFC2544.StreamAlgo;
import com.excentis.products.byteblower.run.objects.RFC2544.TestResult;
import com.excentis.products.byteblower.run.objects.RFC2544.TriggerAlgo;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionDuration;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Logger;

public class RuntimeFrameBlastingBenchmark
extends RuntimeFlow {
    private static final Logger LOGGER = Logger.getGlobal();
    private List<TestResult> results = new ArrayList<TestResult>();
    private final Queue<StreamAlgo> streams;
    private final Queue<TriggerAlgo> triggers;
    private final long duration;
    private long startMomentFlows = Long.MIN_VALUE;
    private long currentIFG;
    private long min = 50L;
    private long max = 10000000L;
    private final double resolution;
    private State currentState = State.WAIT_START;
    private long expectedStart;
    private FrameBlastingBenchmark modelBenchmark;
    private final Context context;
    private long lastRxRate = Long.MAX_VALUE;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeFrameBlastingBenchmark$State = RuntimeFrameBlastingBenchmark.$SWITCH_TABLE$com$excentis$products$byteblower$run$objects$RuntimeFrameBlastingBenchmark$State();
    }

    protected RuntimeFrameBlastingBenchmark(RuntimeScenario rtScenario, FlowMeasurement mFlowInstance, Context context) {
        super(rtScenario, mFlowInstance, RuntimeFlow.Type.UNKNOWN);
        this.modelBenchmark = (FrameBlastingBenchmark)mFlowInstance.getFlow().getFlowTemplate();
        this.currentIFG = this.calculateCenter(this.min, this.max);
        HighResolutionDuration totalDuration = this.mFlowInstanceReader.getDuration();
        int framecount = this.modelBenchmark.getFrames().size();
        this.duration = FrameBlastingBenchmarkReader.getIterationDuration((HighResolutionCalendar)totalDuration, (int)framecount).getTimeInNanoseconds();
        this.expectedStart = this.mFlowInstanceReader.getStartTime().getTimeInMillis();
        this.triggers = new LinkedList<TriggerAlgo>();
        this.streams = new LinkedList<StreamAlgo>();
        this.resolution = this.modelBenchmark.getResolution();
        this.context = context;
    }

    @Override
    public void configureDestination() {
        super.configureDestination();
        RuntimePort src = this.getSourceRuntimePort();
        RuntimePort dest = this.getDestinationRuntimePorts().get(0);
        RuntimePort.State srcState = src.getState();
        RuntimePort.State destState = dest.getState();
        if (srcState == RuntimePort.State.FAILED && destState == RuntimePort.State.FAILED) {
            throw new RuntimeDomainError("Both source and Destination ports failed to initialize.", new RuntimeException());
        }
        if (srcState == RuntimePort.State.FAILED) {
            throw new RuntimeDomainError("Source port failed to initialize.", new RuntimeException());
        }
        if (destState == RuntimePort.State.FAILED) {
            throw new RuntimeDomainError("Destination port failed to initialize.", new RuntimeException());
        }
        if (src.isRuntimeLayer3Ipv4() && dest.isRuntimeLayer3Ipv4()) {
            this.createIPv4Frames(src, dest);
        } else if (src.isRuntimeLayer3Ipv6() && dest.isRuntimeLayer3Ipv6()) {
            this.createIPv6Frames(src, dest);
        }
    }

    private void createIPv4Frames(RuntimePort src, RuntimePort dest) {
        block0: for (BenchmarkFrame frame : this.modelBenchmark.getFrames()) {
            Frame mScoutingFrame = ByteblowerguimodelFactoryImpl.eINSTANCE.createFrame();
            FrameController controller = ControllerFactory.create((Frame)mScoutingFrame);
            controller.createIPv4ScoutingFrame(src.getMacAddressString(), dest.getMacAddressString(), src.getIPAddress(), dest.getIPAddress(), Collections.emptyList(), 5000, 5000, Math.max(60, frame.getSize()));
            controller.setIPv4AutoDestIp(Boolean.valueOf(true));
            controller.setIPv4AutoTotLen(Boolean.valueOf(true));
            controller.setIPv4AutoHeaderCheck(Boolean.valueOf(true));
            controller.setL4AutoUdpChecksum(Boolean.valueOf(true));
            if (src.isMobile()) {
                RuntimeFrameTx rtFrame = new RuntimeFrameTx(this, (Frame)controller.getObject());
                rtFrame.applyDynamicUdpConfiguration();
                this.streams.add(new MobileStreamAlgo(src, this.duration, rtFrame));
            } else {
                CreateFrame.create(this.context, this, (FrameReader)controller).invoke();
            }
            for (RuntimeFrameTx txFRame : src.getOutgoingFrames()) {
                if (txFRame.getModelFbFrame() != controller.getFrame()) continue;
                if (src.isMobile()) break;
                this.streams.add(new BBStreamAlgo(src, this.duration, txFRame));
                break;
            }
            for (RuntimeFrameRx rxFrame : dest.getRxFrames()) {
                if (rxFrame.getModelFbFrame() != controller.getFrame()) continue;
                if (dest.isMobile()) {
                    this.triggers.add(new MobileTriggerAlgo(dest, rxFrame, this.duration));
                    continue block0;
                }
                this.triggers.add(new BBTriggerAlgo(dest, rxFrame));
                continue block0;
            }
        }
    }

    private void createIPv6Frames(RuntimePort src, RuntimePort dest) {
        block0: for (BenchmarkFrame frame : this.modelBenchmark.getFrames()) {
            Frame mScoutingFrame = ByteblowerguimodelFactoryImpl.eINSTANCE.createFrame();
            FrameController controller = ControllerFactory.create((Frame)mScoutingFrame);
            controller.createIPv6ScoutingFrame(src.getMacAddressString(), dest.getMacAddressString(), src.getIPAddress(), dest.getIPAddress(), Collections.emptyList(), 5000, 5000, Math.max(62, frame.getSize()));
            controller.setL3AutoIpv6Destination(Boolean.valueOf(true));
            controller.setL3AutoIpv6PayloadLength();
            controller.setL4AutoUdpChecksum(Boolean.valueOf(true));
            if (src.isMobile()) {
                RuntimeFrameTx rtFrame = new RuntimeFrameTx(this, (Frame)controller.getObject());
                rtFrame.applyDynamicUdpConfiguration();
                this.streams.add(new MobileStreamAlgo(src, this.duration, rtFrame));
            } else {
                CreateFrame.create(this.context, this, (FrameReader)controller).invoke();
            }
            for (RuntimeFrameTx txFrame : src.getOutgoingFrames()) {
                if (txFrame.getModelFbFrame() != controller.getFrame()) continue;
                if (src.isMobile()) {
                    this.streams.add(new MobileStreamAlgo(src, this.duration, txFrame));
                    break;
                }
                this.streams.add(new BBStreamAlgo(src, this.duration, txFrame));
                break;
            }
            for (RuntimeFrameRx rxFrame : dest.getRxFrames()) {
                if (rxFrame.getModelFbFrame() != controller.getFrame()) continue;
                this.triggers.add(new BBTriggerAlgo(dest, rxFrame));
                continue block0;
            }
        }
    }

    private StreamAlgo getCurrentStream() {
        return this.streams.peek();
    }

    private TriggerAlgo getCurrentTrigger() {
        return this.triggers.peek();
    }

    private void init(long ifg) {
        StreamAlgo stream = this.getCurrentStream();
        TriggerAlgo trigger = this.getCurrentTrigger();
        this.currentIFG = ifg;
        stream.prepare(ifg);
        trigger.start();
        stream.start();
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
        if (this.startMomentFlows == Long.MIN_VALUE) {
            this.startMomentFlows = System.currentTimeMillis();
        }
        if (this.currentState == State.WAIT_START && System.currentTimeMillis() - this.startMomentFlows > this.expectedStart) {
            this.currentState = State.IDLE;
        }
        LOGGER.info(String.format("RFC-2544 state machine handling: %s %n", new Object[]{this.currentState}));
        switch (this.currentState) {
            case IDLE: {
                if (this.lastRxRate > 0L && this.lastRxRate < this.max && Math.abs(this.lastRxRate - this.min) / this.min > 2L) {
                    this.init(this.lastRxRate);
                } else {
                    this.init(this.calculateCenter(this.min, this.max));
                }
                this.currentState = State.WAIT_TX;
                break;
            }
            case WAIT_TX: {
                if (!this.getCurrentStream().isDone() || !this.getCurrentTrigger().isDone()) break;
                this.currentState = State.PROCESS;
                break;
            }
            case PROCESS: {
                boolean sufficientlyClose;
                this.process();
                this.getCurrentStream().cleanup();
                this.getCurrentTrigger().cleanup();
                this.currentState = State.IDLE;
                boolean bl = sufficientlyClose = this.min >= this.max || (double)(this.max - this.min) / (double)this.min < 0.3 * this.resolution;
                if (sufficientlyClose) {
                    this.triggers.poll();
                    this.streams.poll();
                    this.min = 50L;
                    this.max = 10000000L;
                    this.lastRxRate = (long)((double)this.lastRxRate / 1.1);
                    if (this.streams.isEmpty()) {
                        this.currentState = State.FINISHED;
                    }
                }
                this.resultsToRefresh(toRefresh);
                break;
            }
        }
    }

    private long calculateCenter(long min, long max) {
        BigInteger bMin = BigInteger.valueOf(min);
        BigInteger bMax = BigInteger.valueOf(max);
        BigInteger center = bMin.multiply(bMax).multiply(BigInteger.valueOf(2L)).divide(bMin.add(bMax));
        return center.longValue();
    }

    public List<TestResult> getResults() {
        return new ArrayList<TestResult>(this.results);
    }

    private void process() {
        StreamAlgo stream = this.getCurrentStream();
        TriggerAlgo trigger = this.getCurrentTrigger();
        long txBytes = stream.bytes();
        long txPackets = stream.packets();
        TestResult currentResult = trigger.calcResult(this.currentIFG, stream.packetSize(), txPackets, txBytes);
        this.results.add(currentResult);
        long rxPackets = currentResult.rxPackets;
        double sourceloss = this.modelBenchmark.getAcceptableLoss();
        double loss = sourceloss * 1.0000000002328306;
        if (txBytes < 1000L || !stream.isOk() || (double)txPackets > (1.0 + loss) * (double)rxPackets) {
            this.min = this.currentIFG + 1L;
            this.lastRxRate = rxPackets > 0L ? currentResult.duration / rxPackets : this.min;
        } else {
            this.max = this.currentIFG;
            this.lastRxRate = this.min;
        }
    }

    @Override
    public long getEnd() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean hasScheduledEnd() {
        return false;
    }

    @Override
    public boolean isDone() {
        if (this.currentState == State.WAIT_START) {
            this.currentState = State.IDLE;
        }
        return State.FINISHED == this.currentState || this.streams.isEmpty() && this.min >= this.max;
    }

    public long getIterationDuration() {
        return this.duration;
    }

    public String getName() {
        return this.mFlowInstanceReader.getFlow().getName();
    }

    @Override
    public void resetResults() {
    }

    public double getResolution() {
        return this.modelBenchmark.getResolution();
    }

    public double getAcceptableLoss() {
        return this.modelBenchmark.getAcceptableLoss();
    }

    @Override
    public String description() {
        if (!this.streams.isEmpty()) {
            StreamAlgo first = this.streams.peek();
            long size = first.packetSize();
            double approxRate = 8000.0 * (double)first.packets() * (double)first.packetSize() / (double)this.duration;
            return String.valueOf(this.name()) + String.format("( %d byte frames, %.02f Mbit/s )", size, approxRate);
        }
        return this.name();
    }

    @Override
    public Collection<? extends RuntimePort> getRuntimePortsForSynchronousStart() {
        return Collections.emptySet();
    }

    private static enum State {
        WAIT_START,
        IDLE,
        PROCESS,
        WAIT_TX,
        FINISHED;

    }
}

