/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.run.filters.ARPOperationFilter;
import com.excentis.products.byteblower.run.filters.ARPSenderProtocolAddressFilter;
import com.excentis.products.byteblower.run.filters.ARPTargetProtocolAddressFilter;
import com.excentis.products.byteblower.run.filters.EthernetEthertypeFilter;
import com.excentis.products.byteblower.run.filters.FrameContentFilter;
import com.excentis.products.byteblower.run.filters.FrameLengthFilter;
import com.excentis.products.byteblower.run.filters.IPAddressFilter;
import com.excentis.products.byteblower.run.filters.PortNumberFilter;
import com.excentis.products.byteblower.run.filters.ProtocolFilter;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameTx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.utils.Utils;
import java.util.List;

public class RuntimeFrameRx
extends RuntimeFrame {
    private RuntimePort rxPort;
    private RuntimeFrameTx rtFrameTx;
    private Filter filter = null;

    RuntimeFrameRx(RuntimeFrameTx rtFrameTx, RuntimePort rxPort) {
        super(rtFrameTx);
        this.rxPort = rxPort;
        this.rtFrameTx = rtFrameTx;
        this.initialize();
    }

    private void initialize() {
        this.insertVlanStack(this.rxPort);
    }

    private Filter getFilter() {
        if (this.filter == null) {
            this.filter = this.createBasicFilter();
        }
        return this.filter;
    }

    public Filter getFilterWithLength() {
        Filter filter = this.getFilter();
        if (!this.rtFbFlow.isRuntimeFrameModifierConfigured()) {
            FrameLengthFilter lengthFilter = FrameLengthFilter.createLengthEqualToFilter(this.getFrameLength());
            filter = Filter.and(filter, (Filter)lengthFilter);
        }
        return filter;
    }

    public Filter getFilterRxSpecific() {
        Filter filter = this.getFilter();
        Filter rxSpecificFilter = null;
        try {
            int frameLength;
            rxSpecificFilter = filter.clone();
            int l25OverheadSize = this.rxPort.getLayer25OverheadSize();
            if (!this.rtFbFlow.isRuntimeFrameModifierConfigured() && (frameLength = this.getFrameLength() + l25OverheadSize) >= 60) {
                FrameLengthFilter lengthFilter = FrameLengthFilter.createLengthEqualToFilter(frameLength);
                rxSpecificFilter = Filter.and(rxSpecificFilter, (Filter)lengthFilter);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot clone filter. " + filter);
        }
        return rxSpecificFilter;
    }

    private Filter createBasicFilter() {
        Filter filter;
        if (this.hasTCPHeader()) {
            filter = this.createBasicTCPFilter();
        } else if (this.hasUDPHeader()) {
            filter = this.createBasicUDPFilter();
        } else if (this.hasIPHeader()) {
            filter = this.createBasicIPFilter();
        } else if (this.hasARPHeader()) {
            filter = this.createBasicARPFilter();
        } else {
            int vlanSkipOffset = this.nofInsertedVlans * 4;
            int ethertype = this.getEthernetEthertypeValue();
            filter = EthernetEthertypeFilter.createEthernetEthertypeFilter(vlanSkipOffset, ethertype);
        }
        return filter;
    }

    private Filter createBasicARPFilter() {
        return Filter.and(ARPOperationFilter.createARPOperation(this.getARPOperation()), ARPSenderProtocolAddressFilter.createARPSPAFilter(this.getARPSenderProtocolAddress()), ARPTargetProtocolAddressFilter.createARPTPAFilter(this.getARPTargetProtocolAddress()));
    }

    private Filter createBasicUDPFilter() {
        int sourceL4Port = this.getSourceL4Port();
        int destinationL4Port = this.getDestinationL4Port();
        return Filter.and(this.createBasicIPFilter(), PortNumberFilter.createUDPSourcePortFilter(sourceL4Port), PortNumberFilter.createUDPDestinationPortFilter(destinationL4Port));
    }

    private int getSourceL4Port() {
        return this.rtFrameTx.getSourceL4Port();
    }

    private int getDestinationL4Port() {
        return this.rtFrameTx.getDestinationL4Port();
    }

    private Filter createBasicTCPFilter() {
        int sourceL4Port = this.getSourceL4Port();
        int destinationL4Port = this.getDestinationL4Port();
        return Filter.and(this.createBasicIPFilter(), PortNumberFilter.createTCPSourcePortFilter(sourceL4Port), PortNumberFilter.createTCPDestinationPortFilter(destinationL4Port));
    }

    private Filter createBasicIPFilter() {
        if (this.hasIPv4Header()) {
            return this.createBasicIPv4Filter();
        }
        if (this.hasIPv6Header()) {
            return this.createBasicIPv6Filter();
        }
        throw new IllegalStateException("Cannot create filter; frame has no IP header");
    }

    private Filter createBasicIPv4Filter() {
        String sourceIp = this.getSourceIpAddress();
        String destinationIp = this.getDestinationIpAddress();
        return Filter.and(ProtocolFilter.createIPv4ProtocolFilter(), IPAddressFilter.createIPv4SourceFilter(sourceIp), IPAddressFilter.createIPv4DestinationFilter(destinationIp));
    }

    private Filter createBasicIPv6Filter() {
        String sourceIp = this.getPrivateSourceIpAddress();
        String destinationIp = this.getDestinationIpAddress();
        return Filter.and(ProtocolFilter.createIPv6ProtocolFilter(), IPAddressFilter.createIPv6SourceFilter(sourceIp), IPAddressFilter.createIPv6DestinationFilter(destinationIp));
    }

    private String getPrivateSourceIpAddress() {
        return this.rtFrameTx.getPrivateSourceIpAddress();
    }

    public String getSourceIpAddress() {
        return this.rtFrameTx.getSourceIpAddress();
    }

    public String getDestinationIpAddress() {
        return this.rtFrameTx.getDestinationIpAddress();
    }

    public void addContentFilter(BPFFilter.Proto protocol, List<Integer> indices) {
        int baseOffset;
        byte[] bytes = this.getPayload(protocol);
        if (bytes.length == 0) {
            throw new IllegalStateException();
        }
        if (this.hasIPv6Header() && (protocol == BPFFilter.Proto.TCP || protocol == BPFFilter.Proto.UDP)) {
            baseOffset = this.getHeader(BPFFilter.Proto.IPv6).length + this.getHeader(protocol).length;
            protocol = BPFFilter.Proto.IPv6;
        } else {
            baseOffset = this.getHeader(protocol).length;
        }
        for (Integer index : indices) {
            FrameContentFilter contentFilter = new FrameContentFilter(protocol, baseOffset + index, Utils.byte2string((byte)bytes[index]));
            this.filter = Filter.and(this.filter, (Filter)contentFilter);
        }
    }
}

