/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.IPv4Configuration;
import com.excentis.products.byteblower.communication.api.IPv6Configuration;
import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.frame.ProtocolField;
import com.excentis.products.byteblower.frame.UDPPacket;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.run.filters.core.BPFFilter;
import com.excentis.products.byteblower.run.objects.RuntimeEthernetIIConfiguration;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimePortDestination;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class RuntimeFrameTx
extends RuntimeFrame {
    Map<RuntimePort, RuntimeFrameRx> rxFrames = new HashMap<RuntimePort, RuntimeFrameRx>();
    protected boolean dynamicConfigurationApplied = false;
    protected String resolvedMacAddress = null;
    protected String publicDestinationIpAddress = null;
    protected Integer publicDestinationL4Port = null;
    protected String publicSourceIpAddress = null;
    protected Integer publicSourceL4Port = null;
    protected Integer privateSourceL4Port = null;
    protected Integer privateDestinationL4Port = null;
    protected String privateSourceIpAddress = null;
    protected String privateDestinationIpAddress = null;

    public RuntimeFrameTx(RuntimeFlow rtFbFlow, Frame mFbFrame) {
        super(rtFbFlow, mFbFrame);
    }

    public Map<RuntimePort, RuntimeFrameRx> getRuntimeFramesRx() {
        return this.rxFrames;
    }

    private void initializeRxFrames() {
        for (RuntimeFrameRx oldFrame : this.rxFrames.values()) {
            for (RuntimePort rxPort : this.rtFbFlow.getDestinationAndEavesdropperRuntimePorts()) {
                rxPort.remove(oldFrame);
            }
        }
        this.rxFrames.clear();
        for (RuntimePort rxPort : this.rtFbFlow.getDestinationAndEavesdropperRuntimePorts()) {
            RuntimeFrameRx rxFrame = new RuntimeFrameRx(this, rxPort);
            rxPort.addArrivingFrame(rxFrame);
            this.rxFrames.put(rxPort, rxFrame);
        }
    }

    public String getResolvedMacAddress() {
        return this.resolvedMacAddress;
    }

    public void setResolvedMacAddress(String resolvedMacAddress) {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Resolved MAC address should not be set after runtime frame dynamic config was applied");
        }
        if (resolvedMacAddress == null) {
            throw new IllegalStateException("Resolved MAC address should not be null");
        }
        this.resolvedMacAddress = resolvedMacAddress;
    }

    public String getPublicSourceIpAddress() {
        return this.publicSourceIpAddress;
    }

    public void setPublicSourceIpAddress(String publicSourceIpAddress) {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Resolved public source IP address should not be set after runtime frame dynamic config was applied");
        }
        if (publicSourceIpAddress == null) {
            throw new IllegalStateException("Resolved public source IP address address should not be null");
        }
        this.publicSourceIpAddress = publicSourceIpAddress;
    }

    public String getPublicDestinationIpAddress() {
        return this.publicDestinationIpAddress;
    }

    public void setPublicDestinationIpAddress(String publicDestinationIpAddress) {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Resolved public destination IP address should not be set after runtime frame dynamic config was applied");
        }
        if (publicDestinationIpAddress == null) {
            throw new IllegalStateException("Resolved public destination IP address address should not be null");
        }
        this.publicDestinationIpAddress = publicDestinationIpAddress;
    }

    public Integer getPublicSourceL4Port() {
        return this.publicSourceL4Port;
    }

    public void setPublicSourceL4Port(int publicSourceL4Port) {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Resolved public source L4 port should not be set after runtime frame dynamic config was applied");
        }
        this.publicSourceL4Port = publicSourceL4Port;
    }

    public Integer getPublicDestinationL4Port() {
        return this.publicDestinationL4Port;
    }

    public void setPublicDestinationL4Port(int publicDestinationL4Port) {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Resolved public destination L4 port should not be set after runtime frame dynamic config was applied");
        }
        this.publicDestinationL4Port = publicDestinationL4Port;
    }

    public String getIPv4SourceAddress() {
        if (this.publicSourceIpAddress != null) {
            return this.publicSourceIpAddress;
        }
        return this.packetIpv4.getSourceAddress();
    }

    public String getIPv4DestinationAddress() {
        if (this.publicDestinationIpAddress != null) {
            return this.publicDestinationIpAddress;
        }
        return this.packetIpv4.getDestinationAddress();
    }

    public void applyDynamicUdpConfiguration() {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Runtime frame dynamic configuration should only be applied once");
        }
        if (this.hasEthernetHeader()) {
            String sampleMAC = "00-FF-31-00-00-00";
            this.packetEthernet.setDA(sampleMAC);
            this.packetEthernet.setSA(sampleMAC);
        }
        if (this.hasIPv4Header()) {
            if (this.mFbFrame.getL3AutoSourceIp().booleanValue()) {
                this.privateSourceIpAddress = this.rtFbFlow.getRuntimeFlowSource().getIPAddress();
                if (!IPv4Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                    if (IPv6Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                        throw new IllegalStateException("IPv4 frame can not have an IPv6 source address.");
                    }
                    throw new IllegalStateException("Invalid IPv4 source address.");
                }
                this.packetIpv4.setSourceAddress(this.privateSourceIpAddress);
            } else {
                this.privateSourceIpAddress = this.packetIpv4.getSourceAddress();
            }
            if (this.mFbFrame.getL3AutoDestIp().booleanValue()) {
                String destinationAddress = this.privateDestinationIpAddress = this.rtFbFlow.getRuntimeFlowDestination().getIPAddress();
                if (this.rtFbFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination && ((RuntimePortDestination)this.rtFbFlow.getRuntimeFlowDestination()).getRuntimePort().isNatted()) {
                    if (this.publicDestinationIpAddress != null) {
                        destinationAddress = this.publicDestinationIpAddress;
                    } else {
                        throw new IllegalStateException("Public destination IP of NATed flow destination should be set before rtFrame applies automatic DIP");
                    }
                }
                if (!IPv4Configuration.IsValidLayer3Address((String)destinationAddress)) {
                    if (IPv6Configuration.IsValidLayer3Address((String)destinationAddress)) {
                        throw new IllegalStateException("IPv4 frame can not have an IPv6 destination address.");
                    }
                    throw new IllegalStateException("Invalid IPv4 destination address.");
                }
                this.packetIpv4.setDestinationAddress(destinationAddress);
            } else {
                this.privateDestinationIpAddress = this.packetIpv4.getDestinationAddress();
            }
            if (this.mFbFrame.getL3AutoHeaderCheck().booleanValue()) {
                this.packetIpv4.doCheckSum();
            }
            this.packetIpv4.calcSize();
            if (this.mFbFrame.getL3AutoTotLen().booleanValue()) {
                this.packetIpv4.autoSetLength();
            }
        } else if (this.hasIPv6Header()) {
            if (this.mFbFrame.getL3AutoIpv6Source().booleanValue()) {
                this.privateSourceIpAddress = this.rtFbFlow.getRuntimeFlowSource().getIPAddress();
                if (!IPv6Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                    if (IPv4Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                        throw new IllegalStateException("IPv6 frame can not have an IPv4 source address.");
                    }
                    throw new IllegalStateException("Invalid IPv6 source address.");
                }
                this.packetIpv6.setSourceAddress(this.privateSourceIpAddress);
            } else {
                this.privateSourceIpAddress = this.packetIpv6.getSourceAddress();
            }
            if (this.mFbFrame.getL3AutoIpv6Destination().booleanValue()) {
                this.privateDestinationIpAddress = this.rtFbFlow.getRuntimeFlowDestination().getIPAddress();
                if (!IPv6Configuration.IsValidLayer3Address((String)this.privateDestinationIpAddress)) {
                    if (IPv4Configuration.IsValidLayer3Address((String)this.privateDestinationIpAddress)) {
                        throw new IllegalStateException("IPv6 frame can not have an IPv4 destination address.");
                    }
                    throw new IllegalStateException("Invalid IPv6 destination address.");
                }
                this.packetIpv6.setDestinationAddress(this.privateDestinationIpAddress);
            } else {
                this.privateDestinationIpAddress = this.packetIpv6.getDestinationAddress();
            }
            this.packetIpv6.calcSize();
            if (this.mFbFrame.getL3AutoIpv6PayloadLength().booleanValue()) {
                this.packetIpv6.autoSetPayloadLength();
            }
        }
        if (this.hasUDPHeader()) {
            this.privateSourceL4Port = this.packetUdp.getSource();
            this.privateDestinationL4Port = this.packetUdp.getDestination();
            int destinationL4Port = this.privateDestinationL4Port;
            if (this.rtFbFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination && ((RuntimePortDestination)this.rtFbFlow.getRuntimeFlowDestination()).getRuntimePort().isNatted()) {
                if (this.publicDestinationL4Port != null) {
                    destinationL4Port = this.publicDestinationL4Port;
                } else {
                    throw new IllegalStateException("Public L4 port of NATed flow destination should be set before rtFrame applies automatic DUDP port");
                }
            }
            this.packetUdp.setDestination(destinationL4Port);
            if (this.mFbFrame.getL4AutoUdpChecksum().booleanValue()) {
                this.packetUdp.doCheckSum();
            }
            this.packetUdp.calcSize();
            if (this.mFbFrame.getL4AutoTotLen().booleanValue()) {
                this.packetUdp.autoSetLength();
            }
        }
        this.initializeRxFrames();
        this.dynamicConfigurationApplied = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyDynamicConfiguration() {
        if (this.dynamicConfigurationApplied) {
            throw new IllegalStateException("Runtime frame dynamic configuration should only be applied once");
        }
        if (!this.hasEthernetHeader()) throw new IllegalStateException("Unexpected non-ethernet rtFrame");
        if (this.mFbFrame.getL2AutoSourceMac().booleanValue()) {
            this.packetEthernet.setSA(((RuntimeEthernetIIConfiguration)this.rtFbFlow.getSourceRuntimePort().getRuntimeLayer2Configuration()).getMacAddressString());
        }
        if (this.mFbFrame.getL2AutoDestMac().booleanValue()) {
            if (this.resolvedMacAddress == null) throw new IllegalStateException("Resolved MAC address should be set before rtFrame applies automatic DMAC");
            this.packetEthernet.setDA(this.resolvedMacAddress);
        }
        if (this.hasARPHeader()) {
            if (this.mFbFrame.getL3AutoArpSPA().booleanValue()) {
                this.packetArp.setSPA(this.rtFbFlow.getRuntimeFlowSource().getIPAddress());
            }
            if (this.mFbFrame.getL3AutoArpTPA().booleanValue()) {
                this.packetArp.setTPA(this.rtFbFlow.getRuntimeFlowDestination().getIPAddress());
            }
            if (this.mFbFrame.getL3AutoArpSHA().booleanValue()) {
                this.packetArp.setSHA(((RuntimeEthernetIIConfiguration)this.rtFbFlow.getSourceRuntimePort().getRuntimeLayer2Configuration()).getMacAddressString());
            }
            if (this.mFbFrame.getL3AutoArpTHA().booleanValue() && this.packetArp.getOperation() == 2) {
                if (this.resolvedMacAddress == null) throw new IllegalStateException("Resolved MAC address should be set before rtFrame applies ARP target DMAC");
                this.packetArp.setTHA(this.resolvedMacAddress);
            } else {
                this.packetArp.setTHA("00-00-00-00-00-00");
            }
        } else if (this.hasIPv4Header()) {
            if (this.mFbFrame.getL3AutoSourceIp().booleanValue()) {
                this.privateSourceIpAddress = this.rtFbFlow.getRuntimeFlowSource().getIPAddress();
                if (!IPv4Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                    if (!IPv6Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) throw new IllegalStateException("Invalid IPv4 source address.");
                    throw new IllegalStateException("IPv4 frame can not have an IPv6 source address.");
                }
                this.packetIpv4.setSourceAddress(this.privateSourceIpAddress);
            } else {
                this.privateSourceIpAddress = this.packetIpv4.getSourceAddress();
            }
            if (this.mFbFrame.getL3AutoDestIp().booleanValue()) {
                String destinationAddress = this.privateDestinationIpAddress = this.rtFbFlow.getRuntimeFlowDestination().getIPAddress();
                if (this.rtFbFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination && ((RuntimePortDestination)this.rtFbFlow.getRuntimeFlowDestination()).getRuntimePort().isNatted()) {
                    destinationAddress = this.publicDestinationIpAddress != null ? this.publicDestinationIpAddress : this.privateDestinationIpAddress;
                }
                if (!IPv4Configuration.IsValidLayer3Address((String)destinationAddress)) {
                    if (!IPv6Configuration.IsValidLayer3Address((String)destinationAddress)) throw new IllegalStateException("Invalid IPv4 destination address.");
                    throw new IllegalStateException("IPv4 frame can not have an IPv6 destination address.");
                }
                this.packetIpv4.setDestinationAddress(destinationAddress);
            } else {
                this.privateDestinationIpAddress = this.packetIpv4.getDestinationAddress();
            }
            if (this.mFbFrame.getL3AutoHeaderCheck().booleanValue()) {
                this.packetIpv4.doCheckSum();
            }
            this.packetIpv4.calcSize();
            if (this.mFbFrame.getL3AutoTotLen().booleanValue()) {
                this.packetIpv4.autoSetLength();
            }
        } else if (this.hasIPv6Header()) {
            if (this.mFbFrame.getL3AutoIpv6Source().booleanValue()) {
                this.privateSourceIpAddress = this.rtFbFlow.getRuntimeFlowSource().getIPAddress();
                if (!IPv6Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) {
                    if (!IPv4Configuration.IsValidLayer3Address((String)this.privateSourceIpAddress)) throw new IllegalStateException("Invalid IPv6 source address.");
                    throw new IllegalStateException("IPv6 frame can not have an IPv4 source address.");
                }
                this.packetIpv6.setSourceAddress(this.privateSourceIpAddress);
            } else {
                this.privateSourceIpAddress = this.packetIpv6.getSourceAddress();
            }
            if (this.mFbFrame.getL3AutoIpv6Destination().booleanValue()) {
                this.privateDestinationIpAddress = this.rtFbFlow.getRuntimeFlowDestination().getIPAddress();
                if (!IPv6Configuration.IsValidLayer3Address((String)this.privateDestinationIpAddress)) {
                    if (!IPv4Configuration.IsValidLayer3Address((String)this.privateDestinationIpAddress)) throw new IllegalStateException("Invalid IPv6 destination address.");
                    throw new IllegalStateException("IPv6 frame can not have an IPv4 destination address.");
                }
                this.packetIpv6.setDestinationAddress(this.privateDestinationIpAddress);
            } else {
                this.privateDestinationIpAddress = this.packetIpv6.getDestinationAddress();
            }
            this.packetIpv6.calcSize();
            if (this.mFbFrame.getL3AutoIpv6PayloadLength().booleanValue()) {
                this.packetIpv6.autoSetPayloadLength();
            }
        }
        if (this.hasUDPHeader()) {
            this.privateSourceL4Port = this.packetUdp.getSource();
            this.privateDestinationL4Port = this.packetUdp.getDestination();
            int destinationL4Port = this.privateDestinationL4Port;
            if (this.rtFbFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination && ((RuntimePortDestination)this.rtFbFlow.getRuntimeFlowDestination()).getRuntimePort().isNatted()) {
                destinationL4Port = this.publicDestinationL4Port != null ? this.publicDestinationL4Port.intValue() : this.privateDestinationL4Port.intValue();
            }
            this.packetUdp.setDestination(destinationL4Port);
            if (this.mFbFrame.getL4AutoUdpChecksum().booleanValue()) {
                this.packetUdp.doCheckSum();
            }
            this.packetUdp.calcSize();
            if (this.mFbFrame.getL4AutoTotLen().booleanValue()) {
                this.packetUdp.autoSetLength();
            }
        } else if (this.hasTCPHeader()) {
            this.privateSourceL4Port = this.packetTcp.getSource();
            this.privateDestinationL4Port = this.packetTcp.getDestination();
            int destinationL4Port = this.privateDestinationL4Port;
            if (this.rtFbFlow.getRuntimeFlowDestination() instanceof RuntimePortDestination && ((RuntimePortDestination)this.rtFbFlow.getRuntimeFlowDestination()).getRuntimePort().isNatted()) {
                destinationL4Port = this.publicDestinationL4Port != null ? this.publicDestinationL4Port.intValue() : this.privateDestinationL4Port.intValue();
            }
            this.packetTcp.setDestination(destinationL4Port);
            if (this.mFbFrame.getL4AutoTcpChecksum().booleanValue()) {
                this.packetTcp.doCheckSum();
            }
            this.packetTcp.calcSize();
        }
        this.initializeRxFrames();
        this.insertVlanStack(this.rtFbFlow.getSourceRuntimePort());
        this.dynamicConfigurationApplied = true;
    }

    @Override
    public void setByteHexString(String hexString) {
        this.initializeRxFrames();
        for (RuntimeFrameRx frame : this.rxFrames.values()) {
            frame.setByteHexString(hexString);
        }
        super.setByteHexString(hexString);
    }

    public RuntimeFrameRx getRuntimeFrameRx(RuntimePort rtPortRx) {
        return this.rxFrames.get(rtPortRx);
    }

    public int getSourceL4Port() {
        return this.publicSourceL4Port != null ? this.publicSourceL4Port : this.privateSourceL4Port;
    }

    public int getDestinationL4Port() {
        return this.privateDestinationL4Port;
    }

    public String getSourceIpAddress() {
        return this.publicSourceIpAddress != null ? this.publicSourceIpAddress : this.privateSourceIpAddress;
    }

    public String getDestinationIpAddress() {
        return this.privateDestinationIpAddress;
    }

    public String getPrivateSourceIpAddress() {
        return this.privateSourceIpAddress;
    }

    public byte[] getUPDPayload() {
        ProtocolField raw = this.getLayer(BPFFilter.Proto.UDP).getField(4);
        int size = raw.getSize();
        byte[] payload = new byte[size / 8];
        raw.dump(payload, 0);
        return payload;
    }

    public void setUDPPayload(byte[] payload) {
        ProtocolField raw = this.getLayer(BPFFilter.Proto.UDP).getField(4);
        for (RuntimeFrameRx rx : this.getRuntimeFramesRx().values()) {
            UDPPacket rxUdpPacket = (UDPPacket)rx.getLayer(BPFFilter.Proto.UDP);
            rxUdpPacket.getField(4).set(8 * payload.length, payload, 0);
            if (this.mFbFrame.getL4AutoUdpChecksum().booleanValue()) {
                rxUdpPacket.doCheckSum();
            }
            if (!this.mFbFrame.getL3AutoHeaderCheck().booleanValue() || !this.hasIPv4Header()) continue;
            Ipv4Packet rxIPv4Packet = (Ipv4Packet)rx.getLayer(BPFFilter.Proto.IPv4);
            rxIPv4Packet.doCheckSum();
        }
        raw.set(8 * payload.length, payload, 0);
        if (this.mFbFrame.getL4AutoUdpChecksum().booleanValue()) {
            this.packetUdp.doCheckSum();
        }
        if (this.mFbFrame.getL3AutoHeaderCheck().booleanValue() && this.hasIPv4Header()) {
            this.packetIpv4.doCheckSum();
        }
    }

    private static boolean isIPv4Unicast(String addr) {
        String[] splitted = addr.split("\\.");
        if (splitted.length == 0) {
            return false;
        }
        try {
            int mostSignificant = Integer.parseInt(splitted[0]);
            return mostSignificant < 224;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isIPv6Unicast(String addr) {
        String[] parts = addr.split(":");
        if (parts.length == 0) {
            return false;
        }
        try {
            int mostSignificant = Integer.parseInt(parts[0], 16);
            return mostSignificant < 65280;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void testUnicast() {
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv4Unicast("1.1.1.1"));
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv4Unicast("192.123.112.143"));
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv4Unicast("23.255.255.255"));
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv4Unicast("10.239.255.255"));
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("255.1.1.1") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("239.123.112.143") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("239.0.0.1") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("240.0.0.1") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("244.23.12.1") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv4Unicast("244.23") ? 1 : 0) != 0);
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv6Unicast("fe::0"));
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv6Unicast("ff::0"));
        Assert.isTrue((boolean)RuntimeFrameTx.isIPv6Unicast("2001:0db8:85a3:0000:0000:8a2e:0370:7334"));
        Assert.isTrue((!RuntimeFrameTx.isIPv6Unicast("ff00:112:2:0") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv6Unicast("ff02:112:2:0") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv6Unicast("ff02:134:2:0") ? 1 : 0) != 0);
        Assert.isTrue((!RuntimeFrameTx.isIPv6Unicast("FFFF:0db8:85a3:0000:0000:8a2e:0370:7334") ? 1 : 0) != 0);
    }

    public boolean isUnicast() {
        RuntimeFrameTx.testUnicast();
        String flowIpDestAddress = this.rtFbFlow.getRuntimeFlowDestination().getIPAddress();
        boolean autoIP = this.mFbFrame.getL3AutoDestIp();
        if (this.packetIpv4 != null) {
            String src = autoIP ? flowIpDestAddress : this.packetIpv4.getDestinationAddress();
            return RuntimeFrameTx.isIPv4Unicast(src);
        }
        if (this.packetIpv6 != null) {
            String src = autoIP ? flowIpDestAddress : this.packetIpv6.getDestinationAddress();
            return RuntimeFrameTx.isIPv6Unicast(src);
        }
        return false;
    }
}

