/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import com.excentis.products.byteblower.run.utils.TimeStamped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuntimeGroupFbFlow
extends RuntimeFlow {
    private Collection<RuntimeFbFlow> children;

    public RuntimeGroupFbFlow(RuntimeScenario runtimeScenario, FlowMeasurement mFlowInstance, Collection<RuntimeFbFlow> blasts) {
        super(runtimeScenario, mFlowInstance, RuntimeFlow.Type.FB);
        this.children = new ArrayList<RuntimeFbFlow>(blasts);
    }

    @Override
    public void resetResults() {
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean hasOutOfSequenceDetection() {
        for (RuntimeFbFlow flow : this.children) {
            if (!flow.hasOutOfSequenceDetection()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLatencyMeasurement() {
        for (RuntimeFbFlow flow : this.children) {
            if (!flow.hasLatencyMeasurement()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RuntimeFlowDestination getRuntimeFlowDestination() {
        RuntimeFlowDestination group = new RuntimeFlowDestination(this){

            public String toString() {
                return RuntimeGroupFbFlow.this.getDestination().getName();
            }

            @Override
            public boolean isNatted() {
                return false;
            }

            @Override
            public String getIPAddress() {
                return "";
            }

            @Override
            public List<RuntimePort> getRuntimePorts() {
                ArrayList<RuntimePort> ports = new ArrayList<RuntimePort>();
                for (RuntimeFlow runtimeFlow : RuntimeGroupFbFlow.this.children) {
                    ports.addAll(runtimeFlow.getDestinationRuntimePorts());
                }
                return ports;
            }
        };
        return group;
    }

    public boolean knows(RuntimeFlow rtFlow) {
        for (RuntimeFlow runtimeFlow : this.children) {
            if (runtimeFlow != rtFlow) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<RuntimePort> getDestinationAndEavesdropperRuntimePortsConfigured() {
        return Collections.emptyList();
    }

    public void visitSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        SnapshotAggregator aggregator = new SnapshotAggregator();
        for (RuntimeFbFlow fbFlow : this.children) {
            fbFlow.visitSnapshots(aggregator);
        }
        aggregator.visitSnapshot(visitor);
    }

    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        SnapshotAggregator aggregator = new SnapshotAggregator();
        for (RuntimeFbFlow fbFlow : this.children) {
            fbFlow.visitCumulativeSnapshots(aggregator);
        }
        aggregator.visitSnapshot(visitor);
    }

    public LocalTriggerResultData txCumulativeSnapshot() {
        LocalTriggerResultData res = new LocalTriggerResultData();
        for (RuntimeFbFlow flow : this.children) {
            if (!flow.isValid()) continue;
            res = flow.txCumulativeSnapshot().add(res);
        }
        return res;
    }

    public List<LocalTriggerResultData> txIntervalSnapshots() {
        ArrayList<LocalTriggerResultData> result = new ArrayList<LocalTriggerResultData>();
        HashMap<Long, LocalTriggerResultData> subresults = new HashMap<Long, LocalTriggerResultData>();
        for (RuntimeFbFlow fbFlow : this.children) {
            for (LocalTriggerResultData local : fbFlow.txIntervalSnapshots()) {
                LocalTriggerResultData updatedResult;
                if (subresults.containsKey(local.TimestampGet())) {
                    LocalTriggerResultData stored = (LocalTriggerResultData)subresults.get(local.TimestampGet());
                    updatedResult = stored.add(local);
                } else {
                    updatedResult = local;
                }
                subresults.put(local.TimestampGet(), updatedResult);
            }
        }
        result.addAll(subresults.values());
        Collections.sort(result, new Comparator<LocalTriggerResultData>(){

            @Override
            public int compare(LocalTriggerResultData arg0, LocalTriggerResultData arg1) {
                return Long.compare(arg0.TimestampGet(), arg1.TimestampGet());
            }
        });
        return result;
    }

    public Collection<RuntimeFbFlow> getChilderen() {
        return new ArrayList<RuntimeFbFlow>(this.children);
    }

    private final class SnapshotAggregator
    implements RuntimeRx.SnapshotVisitor {
        private Map<Long, LocalTriggerResultData> triggerBasicSnaps = new HashMap<Long, LocalTriggerResultData>();
        private Map<Long, LocalLatencyResultData> latencyBasicSnaps = new HashMap<Long, LocalLatencyResultData>();
        private Map<Long, LocalOutOfSequenceResultData> oosSnaps = new HashMap<Long, LocalOutOfSequenceResultData>();
        private LocalLatencyDistributionSnapshot latencyDistribution = new LocalLatencyDistributionSnapshot();
        private RuntimePort hintPort;

        public SnapshotAggregator() {
            RuntimeFlowDestination dest = RuntimeGroupFbFlow.this.getRuntimeFlowDestination();
            this.hintPort = dest.getRuntimePorts().get(0);
        }

        @Override
        public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
            this.latencyDistribution = trigger.add(this.latencyDistribution);
        }

        @Override
        public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
            LocalTriggerResultData[] localTriggerResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalTriggerResultData data = localTriggerResultDataArray[n2];
                LocalTriggerResultData d = new LocalTriggerResultData(data);
                if (this.triggerBasicSnaps.containsKey(d.TimestampGet())) {
                    LocalTriggerResultData known = this.triggerBasicSnaps.get(d.TimestampGet());
                    this.triggerBasicSnaps.put(d.TimestampGet(), known.add(d));
                } else {
                    this.triggerBasicSnaps.put(d.TimestampGet(), d);
                }
                ++n2;
            }
        }

        @Override
        public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
            LocalLatencyResultData[] localLatencyResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalLatencyResultData data = localLatencyResultDataArray[n2];
                LocalLatencyResultData d = new LocalLatencyResultData(data);
                if (this.latencyBasicSnaps.containsKey(d.TimestampGet())) {
                    LocalLatencyResultData known = this.latencyBasicSnaps.get(d.TimestampGet());
                    this.latencyBasicSnaps.put(d.TimestampGet(), known.add(d));
                } else {
                    this.latencyBasicSnaps.put(d.TimestampGet(), d);
                }
                ++n2;
            }
        }

        public void visitSnapshot(RuntimeRx.SnapshotVisitor visitor) {
            ArrayList<LocalTriggerResultData> result = new ArrayList<LocalTriggerResultData>(this.triggerBasicSnaps.values());
            Collections.sort(result, new TimeStamped.TimeSorted());
            visitor.visit(this.hintPort, result.toArray(new LocalTriggerResultData[result.size()]));
            ArrayList<LocalLatencyResultData> resultLatency = new ArrayList<LocalLatencyResultData>(this.latencyBasicSnaps.values());
            Collections.sort(resultLatency, new TimeStamped.TimeSorted());
            visitor.visit(this.hintPort, resultLatency.toArray(new LocalLatencyResultData[resultLatency.size()]));
            ArrayList<LocalOutOfSequenceResultData> resultOOS = new ArrayList<LocalOutOfSequenceResultData>(this.oosSnaps.values());
            Collections.sort(resultOOS, new TimeStamped.TimeSorted());
            visitor.visit(this.hintPort, resultOOS.toArray(new LocalOutOfSequenceResultData[resultOOS.size()]));
            visitor.visit(this.hintPort, this.latencyDistribution);
        }

        @Override
        public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
            LocalOutOfSequenceResultData[] localOutOfSequenceResultDataArray = trigger;
            int n = trigger.length;
            int n2 = 0;
            while (n2 < n) {
                LocalOutOfSequenceResultData data = localOutOfSequenceResultDataArray[n2];
                LocalOutOfSequenceResultData d = new LocalOutOfSequenceResultData(data);
                if (this.oosSnaps.containsKey(d.TimestampGet())) {
                    LocalOutOfSequenceResultData known = this.oosSnaps.get(d.TimestampGet());
                    this.oosSnaps.put(d.TimestampGet(), known.add(d));
                } else {
                    this.oosSnaps.put(d.TimestampGet(), d);
                }
                ++n2;
            }
        }
    }
}

