/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimeHttpClient;
import com.excentis.products.byteblower.run.objects.RuntimeHttpFlow;
import com.excentis.products.byteblower.run.objects.RuntimeHttpServer;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RuntimeGroupHttpFlow
extends RuntimeFlow {
    private Collection<RuntimeHttpFlow> children;
    private TcpFlow mHttpFlowTemplate;
    private ByteBlowerPortGroup modelGroup;
    private WhoIsGrouped groupSituation;

    public RuntimeGroupHttpFlow(RuntimeScenario runtimeScenario, FlowMeasurement mFlowInstance, Collection<RuntimeHttpFlow> blasts) {
        super(runtimeScenario, mFlowInstance, RuntimeFlow.Type.HTTP);
        this.mHttpFlowTemplate = (TcpFlow)mFlowInstance.getFlow().getFlowTemplate();
        this.modelGroup = (ByteBlowerPortGroup)mFlowInstance.getFlow().getDestination();
        this.children = new ArrayList<RuntimeHttpFlow>(blasts);
    }

    @Override
    public void resetResults() {
    }

    @Override
    public void resultsToRefresh(RefreshableSet toRefresh) {
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public RuntimeFlowDestination getRuntimeFlowDestination() {
        RuntimeFlowDestination group = new RuntimeFlowDestination(this){

            public String toString() {
                return RuntimeGroupHttpFlow.this.getDestination().getName();
            }

            @Override
            public boolean isNatted() {
                return false;
            }

            @Override
            public String getIPAddress() {
                return "";
            }

            @Override
            public List<RuntimePort> getRuntimePorts() {
                ArrayList<RuntimePort> ports = new ArrayList<RuntimePort>();
                for (RuntimeFlow runtimeFlow : RuntimeGroupHttpFlow.this.children) {
                    ports.addAll(runtimeFlow.getDestinationRuntimePorts());
                }
                return ports;
            }
        };
        return group;
    }

    @Override
    public List<RuntimePort> getDestinationAndEavesdropperRuntimePortsConfigured() {
        return Collections.emptyList();
    }

    private void determineGrouped() {
        if (this.groupSituation == WhoIsGrouped.Unknown) {
            return;
        }
        HashSet<RuntimePort> clientPorts = new HashSet<RuntimePort>();
        HashSet<RuntimePort> serverPorts = new HashSet<RuntimePort>();
        for (RuntimeHttpFlow child : this.children) {
            RuntimeHttpClient childClient = child.getRuntimeHttpClient();
            RuntimeHttpServer childServer = child.getRuntimeHttpServer();
            if (childClient != null) {
                clientPorts.add(childClient.getRuntimePort());
            }
            if (childServer == null) continue;
            serverPorts.add(childServer.getRuntimePort());
        }
        System.out.println("Client ports: " + clientPorts.size());
        System.out.println("Server ports: " + serverPorts.size());
        this.groupSituation = clientPorts.size() > 1 ? WhoIsGrouped.Client : WhoIsGrouped.Server;
    }

    public RuntimeHttpClient getRuntimeHttpClient() {
        this.determineGrouped();
        Iterator<RuntimeHttpFlow> iterator = this.children.iterator();
        if (iterator.hasNext()) {
            final RuntimeHttpFlow child = iterator.next();
            final RuntimeHttpClient childClient = child.getRuntimeHttpClient();
            return new RuntimeHttpClient(child.getRuntimeDestinationPort(), this){

                @Override
                public int getApiLocalPortNumber() {
                    return 34;
                }

                @Override
                public String getServerClientId() {
                    return null;
                }

                @Override
                public boolean isFinished() {
                    return false;
                }

                @Override
                public HTTPRequestMethod getRequestedMethod() {
                    return child.getRuntimeHttpClient().getRequestedMethod();
                }

                @Override
                public HTTPRequestStatus RequestStatusGet() {
                    System.out.println("Grouped status: " + childClient.RequestStatusGet());
                    return childClient.RequestStatusGet();
                }

                @Override
                public HTTPSessionInfo getHTTPSessionInfo() {
                    return null;
                }

                @Override
                public boolean hasSession() {
                    return false;
                }

                @Override
                public String portName() {
                    if (RuntimeGroupHttpFlow.this.groupSituation == WhoIsGrouped.Client) {
                        return RuntimeGroupHttpFlow.this.modelGroup.getName();
                    }
                    return childClient.portName();
                }

                @Override
                public void resultsToRefresh(RefreshableSet toRefresh) {
                }
            };
        }
        return null;
    }

    public RuntimeHttpServer getRuntimeHttpServer() {
        this.determineGrouped();
        Iterator<RuntimeHttpFlow> iterator = this.children.iterator();
        if (iterator.hasNext()) {
            RuntimeHttpFlow child = iterator.next();
            final RuntimeHttpServer childServer = child.getRuntimeHttpServer();
            return new RuntimeHttpServer(child.getSourceRuntimePort(), null, this.mHttpFlowTemplate){

                @Override
                public int getApiPortNumber() {
                    return 34;
                }

                @Override
                public String portName() {
                    if (RuntimeGroupHttpFlow.this.groupSituation == WhoIsGrouped.Server) {
                        return RuntimeGroupHttpFlow.this.modelGroup.getName();
                    }
                    return childServer.portName();
                }
            };
        }
        return null;
    }

    public Collection<RuntimeHttpFlow> children() {
        return Collections.unmodifiableCollection(this.children);
    }

    public RuntimeHttpFlow.RuntimeHttpMethod getRuntimeHttpMethod() {
        Iterator<RuntimeHttpFlow> iterator = this.children.iterator();
        if (iterator.hasNext()) {
            RuntimeHttpFlow child = iterator.next();
            return child.getRuntimeHttpMethod();
        }
        return RuntimeHttpFlow.RuntimeHttpMethod.GET;
    }

    public List<RuntimeHttpFlow> getChilderen() {
        return new ArrayList<RuntimeHttpFlow>(this.children);
    }

    private static enum WhoIsGrouped {
        Client,
        Server,
        Unknown;

    }
}

