/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.HTTPRequestMethod;
import com.excentis.products.byteblower.communication.api.HTTPRequestStatus;
import com.excentis.products.byteblower.communication.api.HTTPResultHistory;
import com.excentis.products.byteblower.communication.api.HTTPSessionInfo;
import com.excentis.products.byteblower.communication.api.TCPResultHistory;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.LocalHttpResultData;
import com.excentis.products.byteblower.run.utils.LocalTcpResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class RuntimeHttpClient
extends RuntimeObject {
    protected final RuntimePort rtPort;
    private final RuntimeFlow rtHttpFlow;

    RuntimeHttpClient(RuntimePort rtPort, RuntimeFlow rtHttpFlow) {
        this.rtPort = rtPort;
        this.rtHttpFlow = rtHttpFlow;
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.rtPort.getRuntimeScenario();
    }

    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    public String portName() {
        return this.rtPort.getName();
    }

    public RuntimeFlow getRuntimeHttpFlow() {
        return this.rtHttpFlow;
    }

    public String flowName() {
        return this.rtHttpFlow.name();
    }

    public List<RestartEvent> restarts() {
        return Collections.emptyList();
    }

    public abstract int getApiLocalPortNumber();

    public abstract String getServerClientId();

    public abstract boolean isFinished();

    public abstract HTTPRequestMethod getRequestedMethod();

    public abstract HTTPRequestStatus RequestStatusGet();

    public abstract HTTPSessionInfo getHTTPSessionInfo();

    public abstract boolean hasSession();

    public LocalTcpResultData getCumulativeTcpResultData() {
        TCPResultHistory tcpResults;
        if (this.hasSession() && (tcpResults = this.getHTTPSessionInfo().TcpSessionInfoGet().ResultHistoryGet()).CumulativeLengthGet() > 0L) {
            return new LocalTcpResultData(tcpResults.CumulativeLatestGet());
        }
        return new LocalTcpResultData();
    }

    public LocalHttpResultData getCumulativeHTTPResultData() {
        HTTPResultHistory httpResults;
        if (this.hasSession() && (httpResults = this.getHTTPSessionInfo().ResultHistoryGet()).CumulativeLengthGet() > 0L) {
            return new LocalHttpResultData(httpResults.CumulativeLatestGet());
        }
        return new LocalHttpResultData();
    }

    public abstract void resultsToRefresh(RefreshableSet var1);

    public static class RestartEvent {
        public final String failedSessionId;
        public final String reason;
        public final Date when;
        public final long uptime;
        public final long bytes;

        public RestartEvent() {
            this.failedSessionId = "";
            this.when = new Date();
            this.uptime = 0L;
            this.bytes = 0L;
            this.reason = "";
        }

        public RestartEvent(String failedSession, String reason, long uptime, long bytes) {
            this.failedSessionId = failedSession;
            this.reason = reason;
            this.when = new Date();
            this.uptime = uptime;
            this.bytes = bytes;
        }
    }
}

