/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.FrameTagTx;
import com.excentis.products.byteblower.communication.api.OutOfSequence;
import com.excentis.products.byteblower.communication.api.OutOfSequenceResultData;
import com.excentis.products.byteblower.communication.api.OutOfSequenceResultHistory;
import com.excentis.products.byteblower.communication.api.TaggedRx;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeTaggedRx;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;

public class RuntimeOutOfSequence
extends RuntimeTaggedRx {
    public RuntimeOutOfSequence(RuntimeFbFlow rtFbFlow, RuntimePort rtPort) {
        super(rtFbFlow, rtPort, (TaggedRx)rtPort.getApiPort().RxOutOfSequenceBasicAdd());
        long intervalDuration = RuntimeRx.SamplingConfiguration.samplingInterval(rtFbFlow);
        long samples = RuntimeRx.SamplingConfiguration.samples(rtFbFlow);
        this.getApiReceiver().ResultHistoryGet().SamplingBufferLengthSet(samples);
        this.getApiReceiver().ResultHistoryGet().SamplingIntervalDurationSet(intervalDuration);
    }

    public OutOfSequence getApiReceiver() {
        return (OutOfSequence)this.apiRx;
    }

    @Override
    public FrameTagTx getApiFrameTagTx() {
        return this.rtFbFlow.getApiSequenceTagTx();
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public void resetResults() {
        this.getApiReceiver().ResultClear();
        this.getApiReceiver().ResultHistoryGet().Refresh();
        this.getApiReceiver().ResultHistoryGet().Clear();
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        OutOfSequenceResultHistory history = this.getApiReceiver().ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        ArrayList<LocalOutOfSequenceResultData> results = new ArrayList<LocalOutOfSequenceResultData>();
        for (OutOfSequenceResultData snapshot : this.getApiReceiver().ResultHistoryGet().IntervalGet()) {
            results.add(new LocalOutOfSequenceResultData(snapshot));
        }
        if (results.size() > 0) {
            results.remove(results.size() - 1);
        }
        v.visit(this.getRuntimePort(), results.toArray(new LocalOutOfSequenceResultData[results.size()]));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor v) {
        ArrayList<LocalOutOfSequenceResultData> results = new ArrayList<LocalOutOfSequenceResultData>();
        for (OutOfSequenceResultData snapshot : this.getApiReceiver().ResultHistoryGet().CumulativeGet()) {
            results.add(new LocalOutOfSequenceResultData(snapshot));
        }
        if (results.size() > 0) {
            results.remove(results.size() - 1);
        }
        v.visit(this.getRuntimePort(), results.toArray(new LocalOutOfSequenceResultData[results.size()]));
    }
}

