/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.Rx;
import com.excentis.products.byteblower.run.filters.core.Filter;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyBasic;
import com.excentis.products.byteblower.run.objects.RuntimeLatencyDistribution;
import com.excentis.products.byteblower.run.objects.RuntimeMobileDevice;
import com.excentis.products.byteblower.run.objects.RuntimeMobileLatencyRx;
import com.excentis.products.byteblower.run.objects.RuntimeMobileRx;
import com.excentis.products.byteblower.run.objects.RuntimeOutOfSequence;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.objects.RuntimeTriggerBasic;
import com.excentis.products.byteblower.run.objects.RuntimeTriggerSizeDistribution;
import com.excentis.products.byteblower.run.objects.core.RuntimeObject;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class RuntimeRx
extends RuntimeObject {
    protected final RuntimePort rtPort;
    private final RuntimeScenario scenario;
    protected final Rx apiRx;
    protected Filter rxFilter;
    private final List<RuntimeFrameRx> frames;

    protected RuntimeRx(List<RuntimeFrameRx> frames, RuntimePort rtPort, Rx apiRx) {
        this.rtPort = rtPort;
        this.apiRx = apiRx;
        this.scenario = rtPort.getRuntimeScenario();
        this.frames = frames;
        this.updateFilter();
    }

    protected RuntimeRx(RuntimeFbFlow rtFbFlow, RuntimePort rtPort, Rx apiRx) {
        this.rtPort = rtPort;
        this.apiRx = apiRx;
        this.scenario = rtFbFlow.getRuntimeScenario();
        this.frames = rtPort.getRxFrames(rtFbFlow);
        this.updateFilter();
    }

    public RuntimeRx(RuntimeFbFlow rtFbFlow, RuntimeMobileDevice rtPort) {
        this.rtPort = rtPort;
        this.apiRx = null;
        this.scenario = rtFbFlow.getRuntimeScenario();
        this.frames = rtPort.getRxFrames(rtFbFlow);
        this.updateFilter();
    }

    @Override
    public RuntimeScenario getRuntimeScenario() {
        return this.scenario;
    }

    public RuntimePort getRuntimePort() {
        return this.rtPort;
    }

    public Rx getApiReceiver() {
        return this.apiRx;
    }

    public Filter getFilter() {
        return this.rxFilter;
    }

    public void updateFilter() {
        this.rxFilter = this.composeFilter(this.frames);
        this.apiRx.FilterSet(this.rxFilter.toString());
    }

    public abstract void visit(TriggerVisitor var1);

    public abstract void visit(SnapshotVisitor var1);

    public abstract void resetResults();

    private Filter composeFilter(Collection<RuntimeFrameRx> frames) {
        ArrayList<Filter> rxEnhancedFrameFilters = new ArrayList<Filter>();
        for (RuntimeFrameRx rtFrameRx : frames) {
            rxEnhancedFrameFilters.add(rtFrameRx.getFilterRxSpecific());
        }
        Filter filter = Filter.or(rxEnhancedFrameFilters.toArray(new Filter[rxEnhancedFrameFilters.size()]));
        if (this.rtPort.hasVlanFilter()) {
            filter = Filter.and(this.rtPort.getVlanFilter(), filter);
        }
        return filter;
    }

    public boolean isFinished() {
        return true;
    }

    public abstract void gatherRealtimeResults(RefreshableSet var1);

    public abstract void visitCumulativeSnapshots(SnapshotVisitor var1);

    static class SamplingConfiguration {
        static final long EXPECTED_SAMPLES = 500L;
        static final long MIN_SAMPLING_INTERVAL = TimeUnit.MILLISECONDS.toNanos(10L);
        static final long MAX_SAMPLING_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
        static final long TIME_BUFFERED = TimeUnit.SECONDS.toNanos(10L);

        SamplingConfiguration() {
        }

        static long samplingInterval(RuntimeFbFlow rtFbFlow) {
            long intervalDuration = rtFbFlow.getEnd() / 500L;
            intervalDuration = Math.max(MIN_SAMPLING_INTERVAL, intervalDuration);
            intervalDuration = Math.min(MAX_SAMPLING_INTERVAL, intervalDuration);
            return intervalDuration;
        }

        static long samples(RuntimeFbFlow rtFbFlow) {
            long intervalDuration = SamplingConfiguration.samplingInterval(rtFbFlow);
            return TIME_BUFFERED / intervalDuration;
        }
    }

    public static interface SnapshotVisitor {
        public void visit(RuntimePort var1, LocalLatencyResultData[] var2);

        public void visit(RuntimePort var1, LocalTriggerResultData[] var2);

        public void visit(RuntimePort var1, LocalLatencyDistributionSnapshot var2);

        public void visit(RuntimePort var1, LocalOutOfSequenceResultData[] var2);
    }

    public static interface TriggerVisitor {
        public void visit(RuntimeMobileRx var1);

        public void visit(RuntimeTriggerBasic var1);

        public void visit(RuntimeTriggerSizeDistribution var1);

        public void visit(RuntimeLatencyBasic var1);

        public void visit(RuntimeLatencyDistribution var1);

        public void visit(RuntimeOutOfSequence var1);

        public void visit(RuntimeMobileLatencyRx var1);
    }
}

