/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.objects;

import com.excentis.products.byteblower.communication.api.AbstractRefreshableResult;
import com.excentis.products.byteblower.communication.api.Trigger;
import com.excentis.products.byteblower.communication.api.TriggerBasic;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultData;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultHistory;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFrameRx;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeTrigger;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import com.excentis.products.byteblower.run.utils.RefreshableSet;
import java.util.ArrayList;
import java.util.List;

public class RuntimeTriggerBasic
extends RuntimeTrigger {
    public RuntimeTriggerBasic(List<RuntimeFrameRx> frames, RuntimePort rtPort, TriggerBasic trigger) {
        super(frames, rtPort, (Trigger)trigger);
        trigger.ResultHistoryGet().SamplingBufferLengthSet(100L);
        trigger.ResultHistoryGet().SamplingIntervalDurationSet(100000000L);
    }

    RuntimeTriggerBasic(RuntimeFbFlow rtFbFlow, RuntimePort rtPort) {
        this(rtFbFlow, rtPort, rtPort.getApiPort().RxTriggerBasicAdd());
    }

    RuntimeTriggerBasic(RuntimeFbFlow rtFbFlow, RuntimePort rtPort, TriggerBasic apiTrigger) {
        super(rtFbFlow, rtPort, (Trigger)apiTrigger);
        long bufferSize = RuntimeRx.SamplingConfiguration.samples(rtFbFlow);
        long intervalDuration = RuntimeRx.SamplingConfiguration.samplingInterval(rtFbFlow);
        apiTrigger.ResultHistoryGet().SamplingBufferLengthSet(bufferSize);
        apiTrigger.ResultHistoryGet().SamplingIntervalDurationSet(intervalDuration);
    }

    public TriggerBasic getApiReceiver() {
        return (TriggerBasic)this.apiRx;
    }

    @Override
    public void visit(RuntimeRx.TriggerVisitor v) {
        v.visit(this);
    }

    @Override
    public void resetResults() {
        this.getApiReceiver().ResultClear();
        this.getApiReceiver().ResultHistoryGet().Refresh();
        this.getApiReceiver().ResultHistoryGet().Clear();
    }

    @Override
    public void gatherRealtimeResults(RefreshableSet toRefresh) {
        TriggerBasicResultHistory history = this.getApiReceiver().ResultHistoryGet();
        history.Clear();
        toRefresh.add(new AbstractRefreshableResult[]{history});
    }

    @Override
    public void visit(RuntimeRx.SnapshotVisitor v) {
        ArrayList<LocalTriggerResultData> results = new ArrayList<LocalTriggerResultData>();
        for (TriggerBasicResultData data : this.getApiReceiver().ResultHistoryGet().IntervalGet()) {
            results.add(new LocalTriggerResultData(data));
        }
        if (results.size() > 0) {
            results.remove(results.size() - 1);
        }
        v.visit(this.getRuntimePort(), results.toArray(new LocalTriggerResultData[results.size()]));
    }

    @Override
    public void visitCumulativeSnapshots(RuntimeRx.SnapshotVisitor visitor) {
        ArrayList<LocalTriggerResultData> results = new ArrayList<LocalTriggerResultData>();
        for (TriggerBasicResultData data : this.getApiReceiver().ResultHistoryGet().CumulativeGet()) {
            results.add(new LocalTriggerResultData(data));
        }
        if (results.size() > 1) {
            results.remove(results.size() - 1);
        }
        visitor.visit(this.getRuntimePort(), results.toArray(new LocalTriggerResultData[results.size()]));
    }
}

