/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.LatencyDistributionResultSnapshot;
import com.excentis.products.byteblower.run.utils.TimeStamped;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalLatencyDistributionSnapshot
implements TimeStamped {
    private List<Long> packetCountBuckets = new ArrayList<Long>();
    private long packetCountAboveMaximum;
    private long packetCountBelowMinimum;
    private int bucketCount;
    private long bucketWidth;
    private long jitter;
    private long latencyAverage;
    private long latencyMaximum;
    private long latencyMinimum;
    private long packetCountInvalid;
    private long packetCountValid;
    private int frameSizeMin;
    private int frameSizeMax;
    private long byteCount;
    private long packetCount;
    private long timestampLast;
    private long timestampFirst;
    private long timestamp;
    private long rangeMinimum;
    private long rangeMaximum;

    public LocalLatencyDistributionSnapshot(LatencyDistributionResultSnapshot oth) {
        Iterator iterator = new ArrayList(oth.PacketCountBucketsGet()).iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            this.packetCountBuckets.add(val);
        }
        this.bucketCount = oth.BucketCountGet();
        this.bucketWidth = oth.BucketWidthGet();
        this.packetCount = oth.PacketCountGet();
        this.byteCount = oth.ByteCountGet();
        this.packetCountInvalid = oth.PacketCountInvalidGet();
        this.packetCountValid = oth.PacketCountValidGet();
        this.timestamp = oth.TimestampGet();
        if (this.packetCountValid > 0L) {
            this.packetCountAboveMaximum = oth.PacketCountAboveMaximumGet();
            this.packetCountBelowMinimum = oth.PacketCountBelowMinimumGet();
            this.jitter = oth.JitterGet();
            this.latencyAverage = oth.LatencyAverageGet();
            this.latencyMaximum = oth.LatencyMaximumGet();
            this.latencyMinimum = oth.LatencyMinimumGet();
            this.frameSizeMin = oth.FramesizeMinimumGet();
            this.frameSizeMax = oth.FramesizeMaximumGet();
            this.timestampLast = oth.TimestampLastGet();
            this.timestampFirst = oth.TimestampFirstGet();
            this.rangeMinimum = oth.RangeMinimumGet();
            this.rangeMaximum = oth.RangeMaximumGet();
        }
    }

    public LocalLatencyDistributionSnapshot(LocalLatencyDistributionSnapshot oth) {
        this.packetCountBuckets = new ArrayList<Long>(oth.PacketCountBucketsGet());
        this.packetCount = oth.PacketCountGet();
        this.byteCount = oth.ByteCountGet();
        this.packetCountAboveMaximum = oth.PacketCountAboveMaximumGet();
        this.packetCountBelowMinimum = oth.PacketCountBelowMinimumGet();
        this.bucketCount = oth.BucketCountGet();
        this.bucketWidth = oth.BucketWidthGet();
        this.jitter = oth.JitterGet();
        this.latencyAverage = oth.LatencyAverageGet();
        this.latencyMaximum = oth.LatencyMaximumGet();
        this.latencyMinimum = oth.LatencyMinimumGet();
        this.packetCountInvalid = oth.PacketCountInvalidGet();
        this.packetCountValid = oth.PacketCountValidGet();
        this.frameSizeMin = oth.FramesizeMinimumGet();
        this.frameSizeMax = oth.FramesizeMaximumGet();
        this.timestampLast = oth.TimestampLastGet();
        this.timestampFirst = oth.TimestampFirstGet();
        this.timestamp = oth.TimestampGet();
        this.rangeMinimum = oth.RangeMinimumGet();
        this.rangeMaximum = oth.RangeMaximumGet();
    }

    public LocalLatencyDistributionSnapshot() {
    }

    public LocalLatencyDistributionSnapshot add(LocalLatencyDistributionSnapshot oth) {
        LocalLatencyDistributionSnapshot result = new LocalLatencyDistributionSnapshot();
        result.bucketCount = Math.max(this.bucketCount, oth.BucketCountGet());
        if (oth.bucketCount == 0) {
            result.packetCountBuckets.addAll(this.PacketCountBucketsGet());
        } else if (this.bucketCount == 0) {
            result.packetCountBuckets.addAll(oth.PacketCountBucketsGet());
        } else {
            int ctr = 0;
            while (ctr < this.bucketCount) {
                long a = this.packetCountBuckets.get(ctr);
                long b = oth.packetCountBuckets.get(ctr);
                result.packetCountBuckets.add(a + b);
                ++ctr;
            }
        }
        result.packetCount = this.PacketCountGet() + oth.PacketCountGet();
        result.byteCount = this.ByteCountGet() + oth.ByteCountGet();
        result.packetCountAboveMaximum = this.packetCountAboveMaximum + oth.PacketCountAboveMaximumGet();
        result.packetCountBelowMinimum = this.packetCountBelowMinimum + oth.PacketCountBelowMinimumGet();
        result.bucketWidth = Math.max(this.BucketWidthGet(), oth.BucketWidthGet());
        result.jitter = (this.JitterGet() + oth.JitterGet()) / 2L;
        result.latencyAverage = (this.LatencyAverageGet() + oth.LatencyAverageGet()) / 2L;
        result.latencyMaximum = Math.max(this.LatencyMaximumGet(), oth.LatencyMaximumGet());
        result.latencyMinimum = Math.min(this.LatencyMinimumGet(), oth.LatencyMinimumGet());
        result.packetCountInvalid = this.PacketCountInvalidGet() + oth.PacketCountInvalidGet();
        result.packetCountValid = this.PacketCountValidGet() + oth.PacketCountValidGet();
        result.frameSizeMin = Math.min(this.FramesizeMinimumGet(), oth.FramesizeMinimumGet());
        result.frameSizeMax = Math.max(this.FramesizeMaximumGet(), oth.FramesizeMaximumGet());
        result.timestampLast = Math.max(this.TimestampLastGet(), oth.TimestampLastGet());
        result.timestampFirst = Math.min(this.TimestampFirstGet(), oth.TimestampFirstGet());
        result.timestamp = this.TimestampGet();
        result.rangeMinimum = this.RangeMinimumGet();
        result.rangeMaximum = this.RangeMaximumGet();
        return result;
    }

    @Override
    public long TimestampGet() {
        return this.timestamp;
    }

    public long TimestampFirstGet() {
        return this.timestampFirst;
    }

    public long TimestampLastGet() {
        return this.timestampLast;
    }

    public long PacketCountGet() {
        return this.packetCount;
    }

    public long ByteCountGet() {
        return this.byteCount;
    }

    public int FramesizeMaximumGet() {
        return this.frameSizeMax;
    }

    public int FramesizeMinimumGet() {
        return this.frameSizeMin;
    }

    public long PacketCountValidGet() {
        return this.packetCountValid;
    }

    public long PacketCountInvalidGet() {
        return this.packetCountInvalid;
    }

    public long LatencyMinimumGet() {
        return this.latencyMinimum;
    }

    public long LatencyMaximumGet() {
        return this.latencyMaximum;
    }

    public long LatencyAverageGet() {
        return this.latencyAverage;
    }

    public long JitterGet() {
        return this.jitter;
    }

    public long BucketWidthGet() {
        return this.bucketWidth;
    }

    public int BucketCountGet() {
        return this.bucketCount;
    }

    public long PacketCountBelowMinimumGet() {
        return this.packetCountBelowMinimum;
    }

    public long PacketCountAboveMaximumGet() {
        return this.packetCountAboveMaximum;
    }

    public List<Long> PacketCountBucketsGet() {
        return this.packetCountBuckets;
    }

    public long RangeMinimumGet() {
        return this.rangeMinimum;
    }

    public long RangeMaximumGet() {
        return this.rangeMaximum;
    }
}

