/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.NetworkInfo;
import com.excentis.products.byteblower.communication.api.NetworkInfoMonitorResultData;
import com.excentis.products.byteblower.communication.api.NetworkInterface;
import com.excentis.products.byteblower.communication.api.NetworkInterfaceType;
import java.util.ArrayList;
import java.util.Collection;

public class LocalNetworkInfoResult {
    public static final long UNDEFINED_MOMENT = 0L;
    final long timestamp;
    final Collection<LocalNetworkInterface> netifs;

    public LocalNetworkInfoResult(NetworkInfoMonitorResultData data) {
        this.timestamp = data.TimestampGet();
        this.netifs = new ArrayList<LocalNetworkInterface>();
        for (NetworkInterface info : data.InterfaceGet()) {
            LocalNetworkInterface result = new LocalNetworkInterface(info);
            this.netifs.add(result);
        }
    }

    public LocalNetworkInfoResult(NetworkInfo data) {
        this.timestamp = 0L;
        this.netifs = new ArrayList<LocalNetworkInterface>();
        for (NetworkInterface api : data.InterfaceGet()) {
            this.netifs.add(new LocalNetworkInterface(api));
        }
    }

    public long TimestampGet() {
        return this.timestamp;
    }

    public Collection<LocalNetworkInterface> InterfaceGet() {
        return this.netifs;
    }

    public boolean untimedResults() {
        return this.timestamp == 0L;
    }

    public static class LocalNetworkInterface {
        public final String name;
        public final long rssi;
        public final String bssid;
        public final String ssid;
        public final NetIfType type;

        public LocalNetworkInterface(NetworkInterface info) {
            this.name = info.DisplayNameGet();
            this.rssi = info.WiFiRssiGet();
            this.bssid = info.WiFiBssidGet();
            this.ssid = info.WiFiSsidGet();
            this.type = info.TypeGet() == NetworkInterfaceType.Ethernet ? NetIfType.Ethernet : (info.TypeGet() == NetworkInterfaceType.WiFi ? NetIfType.WiFi : NetIfType.Other);
        }
    }

    public static enum NetIfType {
        Ethernet,
        WiFi,
        Other;

    }
}

