/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.run.utils;

import com.excentis.products.byteblower.communication.api.LatencyBasicResultData;
import com.excentis.products.byteblower.communication.api.StreamResultData;
import com.excentis.products.byteblower.communication.api.TriggerBasicResultData;
import com.excentis.products.byteblower.run.utils.TimeStamped;

public class LocalTriggerResultData
implements TimeStamped {
    private long timestamp;
    private long timestampFirst = Long.MAX_VALUE;
    private long timestampLast = Long.MIN_VALUE;
    private long packetCount;
    private long byteCount;
    private int frameSizeMax;
    private int frameSizeMin;
    private long intervalDuration;

    public LocalTriggerResultData() {
    }

    public LocalTriggerResultData(StreamResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.intervalDuration = orig.IntervalDurationGet();
        if (this.packetCount > 0L) {
            this.timestampFirst = orig.TimestampFirstGet();
            this.timestampLast = orig.TimestampLastGet();
            this.frameSizeMin = orig.FramesizeMinimumGet();
            this.frameSizeMax = orig.FramesizeMaximumGet();
        }
    }

    public LocalTriggerResultData(LocalTriggerResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.timestampFirst = orig.TimestampFirstGet();
        this.timestampLast = orig.TimestampLastGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.frameSizeMax = orig.FramesizeMaximumGet();
        this.frameSizeMin = orig.FramesizeMinimumGet();
        this.intervalDuration = orig.IntervalDurationGet();
    }

    public LocalTriggerResultData(TriggerBasicResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.intervalDuration = orig.IntervalDurationGet();
        if (this.packetCount > 0L) {
            this.timestampFirst = orig.TimestampFirstGet();
            this.timestampLast = orig.TimestampLastGet();
            this.frameSizeMin = 0;
            this.frameSizeMax = 0;
        }
    }

    public LocalTriggerResultData(LatencyBasicResultData orig) {
        this.timestamp = orig.TimestampGet();
        this.packetCount = orig.PacketCountGet();
        this.byteCount = orig.ByteCountGet();
        this.intervalDuration = orig.IntervalDurationGet();
        if (this.packetCount > 0L) {
            this.timestampFirst = orig.TimestampFirstGet();
            this.timestampLast = orig.TimestampLastGet();
            this.frameSizeMin = 0;
            this.frameSizeMax = 0;
        }
    }

    @Override
    public long TimestampGet() {
        return this.timestamp;
    }

    public long TimestampFirstGet() {
        return this.timestampFirst;
    }

    public long TimestampLastGet() {
        return this.timestampLast;
    }

    public long PacketCountGet() {
        return this.packetCount;
    }

    public long ByteCountGet() {
        return this.byteCount;
    }

    public int FramesizeMaximumGet() {
        return this.frameSizeMax;
    }

    public int FramesizeMinimumGet() {
        return this.frameSizeMin;
    }

    public long IntervalDurationGet() {
        return this.intervalDuration;
    }

    public LocalTriggerResultData add(LocalTriggerResultData oth) {
        LocalTriggerResultData result = new LocalTriggerResultData();
        result.timestamp = this.timestamp;
        result.intervalDuration = this.intervalDuration;
        result.timestampFirst = Math.min(oth.timestampFirst, this.timestampFirst);
        result.timestampLast = Math.max(oth.timestampLast, this.timestampLast);
        result.packetCount = oth.packetCount + this.packetCount;
        result.byteCount = oth.byteCount + this.byteCount;
        result.frameSizeMax = Math.max(oth.frameSizeMax, this.frameSizeMax);
        result.frameSizeMin = Math.min(oth.frameSizeMin, this.frameSizeMin);
        return result;
    }
}

