/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner.workers;

import com.excentis.products.byteblower.bear.operations.Operation;

public abstract class ActiveWaitOperationExecutor {
    private final String workerName;
    private final Object finishWaitObj = new Object();
    private boolean operationFinished = false;

    protected ActiveWaitOperationExecutor(String workerName) {
        this.workerName = workerName;
    }

    public String getName() {
        return this.workerName;
    }

    protected void performAndWait(Operation op) throws Operation.IsRunningException, Operation.HasRunnedException {
        this.setupWaitFinish();
        op.perform();
        this.waitForFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupWaitFinish() {
        Object object = this.finishWaitObj;
        synchronized (object) {
            this.operationFinished = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForFinish() {
        Object object = this.finishWaitObj;
        synchronized (object) {
            while (true) {
                if (this.operationFinished) {
                    return;
                }
                try {
                    this.finishWaitObj.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected abstract class ActiveWaitCallback<ReturnType>
    implements Operation.Callback<ReturnType> {
        protected ActiveWaitCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void done(ReturnType returnValue) {
            Object object = ActiveWaitOperationExecutor.this.finishWaitObj;
            synchronized (object) {
                this.handleDone(returnValue);
                ActiveWaitOperationExecutor.this.operationFinished = true;
                ActiveWaitOperationExecutor.this.finishWaitObj.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void failed(Exception t) {
            Object object = ActiveWaitOperationExecutor.this.finishWaitObj;
            synchronized (object) {
                this.handleFailed(t);
                ActiveWaitOperationExecutor.this.operationFinished = true;
                ActiveWaitOperationExecutor.this.finishWaitObj.notifyAll();
            }
        }

        protected abstract void handleDone(ReturnType var1);

        protected abstract void handleFailed(Exception var1);
    }
}

