/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.runner.workers;

import com.excentis.products.byteblower.bear.BearApi;
import com.excentis.products.byteblower.bear.ProjectReference;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.runner.workers.ActiveWaitOperationExecutor;
import com.excentis.products.byteblower.runner.workers.ProjectLoader;

public class OpenXmlProjectWorker
extends ProjectLoader {
    private final String xmlProjectString;

    public OpenXmlProjectWorker(BearApi bearApi, String xmlProjectString) {
        super(bearApi);
        this.xmlProjectString = xmlProjectString;
    }

    @Override
    public ProjectReference run() throws Operation.IsRunningException, Operation.HasRunnedException, Exception {
        Operation op = this.bearApi.getOpenXmlProjectOperation(this.xmlProjectString, (Operation.Callback)new ActiveWaitOperationExecutor.ActiveWaitCallback<ProjectReference>((ActiveWaitOperationExecutor)this){

            @Override
            public void handleDone(ProjectReference projectReference) {
                OpenXmlProjectWorker.this.projectReference = projectReference;
            }

            @Override
            protected void handleFailed(Exception t) {
                OpenXmlProjectWorker.this.error = t;
            }
        });
        this.performAndWait(op);
        if (this.error != null) {
            throw this.error;
        }
        if (this.projectReference != null) {
            return this.projectReference;
        }
        throw new IllegalStateException("OpenProject worker should either contain a project reference or an exception by now");
    }
}

