/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterfaceType implements Enumerator
{
    UNKNOWN(0, "unknown", "unknown"),
    TRUNKING(1, "trunking", "trunking"),
    NONTRUNKING(2, "nontrunking", "nontrunking"),
    USB(3, "usb", "usb");

    public static final int UNKNOWN_VALUE = 0;
    public static final int TRUNKING_VALUE = 1;
    public static final int NONTRUNKING_VALUE = 2;
    public static final int USB_VALUE = 3;
    private static final InterfaceType[] VALUES_ARRAY;
    public static final List<InterfaceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InterfaceType[]{UNKNOWN, TRUNKING, NONTRUNKING, USB};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InterfaceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterfaceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterfaceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterfaceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterfaceType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return TRUNKING;
            }
            case 2: {
                return NONTRUNKING;
            }
            case 3: {
                return USB;
            }
        }
        return null;
    }

    private InterfaceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

