/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LinkType implements Enumerator
{
    ETHERNET(0, "ethernet", "ethernet"),
    USB(1, "usb", "usb");

    public static final int ETHERNET_VALUE = 0;
    public static final int USB_VALUE = 1;
    private static final LinkType[] VALUES_ARRAY;
    public static final List<LinkType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LinkType[]{ETHERNET, USB};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LinkType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LinkType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LinkType get(int value) {
        switch (value) {
            case 0: {
                return ETHERNET;
            }
            case 1: {
                return USB;
            }
        }
        return null;
    }

    private LinkType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

