/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MobileType implements Enumerator
{
    UNKNOWN(0, "unknown", "unknown"),
    ANDROID(1, "android", "android"),
    IOS(2, "ios", "ios"),
    LINUX(3, "linux", "linux"),
    OSX(4, "osx", "osx"),
    WINDOWS(5, "windows", "windows");

    public static final int UNKNOWN_VALUE = 0;
    public static final int ANDROID_VALUE = 1;
    public static final int IOS_VALUE = 2;
    public static final int LINUX_VALUE = 3;
    public static final int OSX_VALUE = 4;
    public static final int WINDOWS_VALUE = 5;
    private static final MobileType[] VALUES_ARRAY;
    public static final List<MobileType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MobileType[]{UNKNOWN, ANDROID, IOS, LINUX, OSX, WINDOWS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MobileType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MobileType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MobileType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MobileType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MobileType get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return ANDROID;
            }
            case 2: {
                return IOS;
            }
            case 3: {
                return LINUX;
            }
            case 4: {
                return OSX;
            }
            case 5: {
                return WINDOWS;
            }
        }
        return null;
    }

    private MobileType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

