/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PortLinkStatus implements Enumerator
{
    OFFLINE(0, "offline", "offline"),
    ONLINE(1, "online", "online"),
    UNKNOWN(3, "unknown", "unknown");

    public static final int OFFLINE_VALUE = 0;
    public static final int ONLINE_VALUE = 1;
    public static final int UNKNOWN_VALUE = 3;
    private static final PortLinkStatus[] VALUES_ARRAY;
    public static final List<PortLinkStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PortLinkStatus[]{OFFLINE, ONLINE, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PortLinkStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortLinkStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortLinkStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PortLinkStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PortLinkStatus get(int value) {
        switch (value) {
            case 0: {
                return OFFLINE;
            }
            case 1: {
                return ONLINE;
            }
            case 3: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private PortLinkStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

