/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.server.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ServerLinkStatus implements Enumerator
{
    UNKNOWN(0, "unknown", "unknown"),
    OFFLINE(1, "offline", "offline"),
    ONLINE(2, "online", "online"),
    INCOMPATIBLE_VERSION(3, "incompatible_version", "incompatible_version");

    public static final int UNKNOWN_VALUE = 0;
    public static final int OFFLINE_VALUE = 1;
    public static final int ONLINE_VALUE = 2;
    public static final int INCOMPATIBLE_VERSION_VALUE = 3;
    private static final ServerLinkStatus[] VALUES_ARRAY;
    public static final List<ServerLinkStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ServerLinkStatus[]{UNKNOWN, OFFLINE, ONLINE, INCOMPATIBLE_VERSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ServerLinkStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ServerLinkStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ServerLinkStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ServerLinkStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ServerLinkStatus get(int value) {
        switch (value) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return OFFLINE;
            }
            case 2: {
                return ONLINE;
            }
            case 3: {
                return INCOMPATIBLE_VERSION;
            }
        }
        return null;
    }

    private ServerLinkStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

