/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class FileNativeHTTP {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean willUseProxy(String targetPath) {
        ProxySelector defaultProxy = ProxySelector.getDefault();
        try {
            Proxy proxy;
            Iterator<Proxy> iterator = defaultProxy.select(new URI(targetPath)).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((proxy = iterator.next()) == Proxy.NO_PROXY);
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static String version() {
        Version v = FrameworkUtil.getBundle(FileNativeHTTP.class).getVersion();
        return v.toString();
    }

    private static Map<String, String> parseArrayHeader(String header) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (header.startsWith("[")) {
            header = header.substring(1);
        }
        if (header.endsWith("]")) {
            header = header.substring(0, header.length() - 1);
        }
        Pattern keyValPattern = Pattern.compile(" *([^=]*)=\"*([^\"]*)\"*.*");
        String[] stringArray = header.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arrayElement = stringArray[n2];
            Matcher match = keyValPattern.matcher(arrayElement);
            if (match.find()) {
                result.put(match.group(1), match.group(2));
            }
            ++n2;
        }
        return result;
    }

    private static String randId(int charCount) {
        String baseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toLowerCase();
        StringBuilder result = new StringBuilder();
        SecureRandom rand = new SecureRandom();
        int ctr = 0;
        while (ctr < charCount) {
            int idx = rand.nextInt(letters.length());
            result.append(letters.charAt(idx));
            ++ctr;
        }
        return result.toString();
    }

    private static String byteArrayToHex(byte[] arr) {
        StringBuilder result = new StringBuilder(arr.length * 2);
        byte[] byArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            byte val = byArray[n2];
            result.append(String.format("%02x", val));
            ++n2;
        }
        return result.toString();
    }

    private static String md5(String in) {
        String badResult = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] theMD5digest = md.digest(in.getBytes());
            return FileNativeHTTP.byteArrayToHex(theMD5digest);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static File postDownload(UsernamePasswordCredentials provider, String serverName, String path, IProgressMonitor monitor, Map<String, String> settings) throws HttpException {
        Gson gson = new Gson();
        HttpRequest.BodyPublisher uploadBody = HttpRequest.BodyPublishers.ofString(gson.toJson(settings));
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(path)).header("Content-Type", "application/json").header("accept", "application/octet-stream").header("User-Agent", String.format("ByteBlower-RCP-proxy/%s", FileNativeHTTP.version())).POST(uploadBody);
            return FileNativeHTTP.doRequest(provider, requestBuilder, path, monitor);
        }
        catch (URISyntaxException badUrl) {
            throw new HttpException("Server is not available at requested address.");
        }
    }

    private static HttpRequest digestAuthentication(UsernamePasswordCredentials provider, String path, HttpRequest.Builder requestBuilder, HttpResponse<Void> upload) throws HttpException, URISyntaxException {
        List<String> authChallenge = upload.headers().allValues("www-authenticate");
        if (authChallenge.size() != 1) {
            throw new HttpException("Unknown update server");
        }
        String headerString = authChallenge.get(0);
        String digestKey = "digest";
        if (!headerString.toLowerCase().startsWith("digest")) {
            throw new HttpException("Requires HTTP Digest Autentication");
        }
        String headerValueStrings = headerString.substring("digest".length());
        Map<String, String> headerValues = FileNativeHTTP.parseArrayHeader(headerValueStrings);
        String ha1Raw = String.format("%s:%s:%s", provider.getUserName(), headerValues.get("realm"), provider.getPassword());
        String ha1 = FileNativeHTTP.md5(ha1Raw);
        String ha2Raw = String.format("%s:%s", "POST", new URI(path).getPath());
        String ha2 = FileNativeHTTP.md5(ha2Raw);
        String nonceCounter = "00000001";
        String cnonce = FileNativeHTTP.randId(44);
        String responseRaw = String.format("%s:%s:%s:%s:%s:%s", ha1, headerValues.get("nonce"), nonceCounter, cnonce, headerValues.get("qop"), ha2);
        String response = FileNativeHTTP.md5(responseRaw);
        String authorizationValue = String.format("Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", cnonce=\"%s\", nc=%s, qop=%s, response=\"%s\", algorithm=\"%s\"", provider.getUserName(), headerValues.get("realm"), headerValues.get("nonce"), new URI(path).getPath(), cnonce, nonceCounter, headerValues.get("qop"), response, "MD5");
        requestBuilder = requestBuilder.header("Authorization", authorizationValue);
        HttpRequest authorizedRequest = requestBuilder.build();
        return authorizedRequest;
    }

    public static File download(UsernamePasswordCredentials provider, String serverName, String path, IProgressMonitor monitor) throws HttpException {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(new URI(path)).header("Content-Type", "application/json").header("accept", "application/octet-stream").header("User-Agent", String.format("ByteBlower-RCP-proxy/%s", FileNativeHTTP.version())).GET();
            return FileNativeHTTP.doRequest(provider, requestBuilder, path, monitor);
        }
        catch (URISyntaxException badUrl) {
            throw new HttpException("Server is not available at requested address.");
        }
    }

    private static File doRequest(UsernamePasswordCredentials provider, HttpRequest.Builder requestBuilder, String path, IProgressMonitor monitor) throws HttpException {
        block8: {
            ExecutorService ex = Executors.newCachedThreadPool();
            try {
                HttpRequest req = requestBuilder.build();
                ProxySelector defaultProxy = ProxySelector.getDefault();
                HttpClient client = HttpClient.newBuilder().proxy(defaultProxy).executor(ex).build();
                HttpResponse<Void> authResponse = client.send(req, HttpResponse.BodyHandlers.discarding());
                int statusCode = authResponse.statusCode();
                if (statusCode == 401) {
                    HttpRequest req2 = FileNativeHTTP.digestAuthentication(provider, path, requestBuilder, authResponse);
                    Path uploadResult = Files.createTempFile("bbdl_update", ".tmp", new FileAttribute[0]);
                    uploadResult.toFile().deleteOnExit();
                    CompletableFuture<HttpResponse<Path>> download = client.sendAsync(req2, HttpResponse.BodyHandlers.ofFile(uploadResult));
                    HttpResponse<Path> result = FileNativeHTTP.waitOnCompletion(monitor, download);
                    if (result.statusCode() >= 200 && result.statusCode() < 300) {
                        File updateArchive = uploadResult.toFile();
                        if (updateArchive.exists()) {
                            return updateArchive;
                        }
                        throw new HttpException("Unable to save update-archive to file on client");
                    }
                    if (result.statusCode() == 401) {
                        throw new HttpException("ByteBlower Server License expired");
                    }
                    break block8;
                }
                throw new HttpException("Expects login, none asked by download server");
            }
            catch (IOException e) {
                throw new HttpException("Unable to save update-archive on client.");
            }
            catch (URISyntaxException e) {
                throw new HttpException("Address to update server is invalid.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new HttpException("Unknown ByteBlower GUI error");
    }

    private static <T> T waitOnCompletion(IProgressMonitor monitor, Future<T> download) throws InterruptedException, HttpException {
        SubMonitor downloadMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        downloadMonitor.beginTask("Downloading update", 0);
        while (!download.isDone()) {
            if (monitor.isCanceled()) {
                download.cancel(true);
                throw new InterruptedException();
            }
            downloadMonitor.setWorkRemaining(100).split(1);
            Thread.sleep(64L);
        }
        try {
            return download.get();
        }
        catch (ExecutionException base) {
            Throwable orig = base.getCause();
            throw new HttpException("Unable to download Update " + orig.getMessage());
        }
    }

    private FileNativeHTTP() {
    }

    public static class HttpException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HttpException(String message) {
            super(message);
        }
    }
}

