/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh;

import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.UpgradeStepListener;
import com.excentis.products.byteblower.utils.ssh.steps.CheckConnectionStep;
import org.eclipse.core.runtime.IProgressMonitor;

public class Upgrade {
    protected boolean inError = false;
    protected final IProgressMonitor monitor;
    protected String serverAddress;
    private UpgradeStepListener listener;
    protected UpgradeStep currentStep;

    public Upgrade(String serverAddress, IProgressMonitor monitor) {
        this.serverAddress = serverAddress;
        this.monitor = monitor;
        this.listener = null;
    }

    public boolean isInError() {
        return this.inError;
    }

    public void setListener(UpgradeStepListener listener) {
        this.listener = listener;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public boolean run() {
        this.monitor.beginTask("Upgrade Server", 5);
        this.currentStep = new CheckConnectionStep(this.serverAddress);
        while (this.currentStep != UpgradeStep.NO_NEXT_STEP) {
            this.handleStepStart(this.currentStep);
            UpgradeStep next = this.currentStep.next(this.monitor);
            if (!this.wasSuccessfull(this.currentStep)) {
                this.handleStepError(this.currentStep);
                return false;
            }
            this.handleStepFinished(this.currentStep);
            this.currentStep = next;
        }
        this.monitor.done();
        this.handleDone();
        return true;
    }

    private boolean wasSuccessfull(UpgradeStep step) {
        return step.canProgress();
    }

    private void handleStepError(UpgradeStep step) {
        this.listener.onStepError(step.getName(), step.getErrorMessage());
        this.monitor.setTaskName("Cancelling, ...");
        this.monitor.setCanceled(true);
        this.currentStep = null;
    }

    private void handleStepStart(UpgradeStep step) {
        this.monitor.setTaskName(step.getName());
        this.listener.onStepStarted(step.getName());
    }

    private void handleStepFinished(UpgradeStep step) {
        this.listener.onStepFinished(step.getName());
        this.monitor.worked(1);
    }

    private void handleDone() {
        this.listener.onFinalStepDone();
    }
}

