/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.core;

import com.excentis.products.byteblower.utils.ssh.core.ServerScpException;
import com.excentis.products.byteblower.utils.ssh.core.ServerSsh;
import com.jcraft.jsch.Channel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class FileSCP {
    private static final Logger LOGGER = Logger.getGlobal();
    private final ServerSsh ssh;

    public FileSCP(ServerSsh ssh) {
        this.ssh = ssh;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadFile(File local, String remoteFile, IProgressMonitor monitor) throws ServerScpException {
        String command = "scp -t " + remoteFile;
        Channel channel = this.ssh.createChannel();
        this.ssh.initializeScpCommand(command);
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (FileInputStream copyData = new FileInputStream(local);){
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                long filesize = local.length();
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Upload file to server", (int)((int)filesize));
                command = "C0644 " + filesize + " ";
                command = String.valueOf(command) + remoteFile;
                command = String.valueOf(command) + "\n";
                out.write(command.getBytes());
                out.flush();
                if (this.checkAck(in) != 0) {
                    return false;
                }
                byte[] buffer = new byte[1024];
                while (true) {
                    int len = copyData.read(buffer, 0, buffer.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (len <= 0) {
                        buffer[0] = 0;
                        out.write(buffer, 0, 1);
                        out.flush();
                        if (this.checkAck(in) != 0) {
                            return false;
                        }
                        break;
                    }
                    out.write(buffer, 0, len);
                    sub.worked(len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ServerScpException("Unable to upload file to server");
        }
        catch (OperationCanceledException e) {
            throw new ServerScpException("upload file to server canceled");
        }
        channel.disconnect();
        return true;
    }

    public File fetchFile(String remoteFile) throws ServerScpException {
        File target;
        try {
            target = File.createTempFile("bbb_support", "tmp");
        }
        catch (IOException e) {
            throw new ServerScpException("Unable to create local temporary file");
        }
        String command = "scp -f " + remoteFile;
        Channel channel = this.ssh.createChannel();
        this.ssh.initializeScpCommand(command);
        try {
            int c;
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            byte[] buf = new byte[1024];
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            while ((c = this.checkAck(in)) == 67 || c == 68) {
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (in.read(buf, 0, 1) >= 0 && buf[0] != 32) {
                    filesize = filesize * 10L + (long)buf[0] - 48L;
                }
                String file = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                file = new String(buf, 0, i);
                LOGGER.info("filesize=" + filesize + ", file=" + file);
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (filesize == 0L) continue;
                Throwable throwable = null;
                Object var13_17 = null;
                try (FileOutputStream fos = new FileOutputStream(target);){
                    int foo;
                    do {
                        foo = (long)buf.length < filesize ? buf.length : (int)filesize;
                        if ((foo = in.read(buf, 0, foo)) < 0) {
                            break;
                        }
                        fos.write(buf, 0, foo);
                    } while ((filesize -= (long)foo) != 0L);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (this.checkAck(in) != 0) {
                    LOGGER.warning("unexcepted ack");
                    return target;
                }
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new ServerScpException("Unable to download file from server");
        }
        catch (OperationCanceledException e) {
            throw new ServerScpException("Download file from server canceled");
        }
        channel.disconnect();
        return target;
    }

    private int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                LOGGER.warning(() -> "CheckAck Error: " + sb.toString());
            }
            if (b == 2) {
                LOGGER.warning(() -> "CheckAck Fatal error" + sb.toString());
            }
        }
        return b;
    }
}

