/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.core;

import com.excentis.products.byteblower.utils.ssh.Activator;
import com.excentis.products.byteblower.utils.ssh.UserPrompt;
import com.excentis.products.byteblower.utils.ssh.core.FileSCP;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.core.ServerScpException;
import com.excentis.products.byteblower.utils.ssh.core.ServerSshException;
import com.excentis.products.byteblower.utils.ssh.io.LimitedSizeStream;
import com.excentis.products.byteblower.utils.ssh.io.StringBackend;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jsch.ui.UserInfoPrompter;

public class ServerSsh
implements IServerSsh {
    private final JSch jsch = new JSch();
    private final String serverAddress;
    private final Session session;
    private Channel channel;
    private OutputStream output;
    private InputStream input;

    public ServerSsh(String serverAddress) {
        this.serverAddress = serverAddress;
        this.session = this.initSession(null);
    }

    public ServerSsh(String serverAddress, UserPrompt userPrompt) {
        this.serverAddress = serverAddress;
        this.session = this.initSession(userPrompt);
    }

    private Session initSession(UserPrompt userPrompt) throws ServerSshException {
        try {
            Session session = this.jsch.getSession("root", this.serverAddress);
            if (userPrompt == null) {
                UserInfoPrompter prompter = new UserInfoPrompter(session);
                session.setUserInfo((UserInfo)prompter);
            } else {
                session.setUserInfo(userPrompt.getUserInfo());
            }
            session.connect(30000);
            return session;
        }
        catch (JSchException e) {
            this.disconnect();
            throw new ServerSshException("Unable To Create Session");
        }
    }

    private void disconnect() throws ServerSshException {
        if (this.output != null) {
            try {
                this.output.close();
                this.input.close();
            }
            catch (IOException e) {
                throw new ServerSshException("Unable to close IO streams");
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
    }

    private void disconnectChannel() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public Channel createChannel() throws ServerSshException {
        try {
            this.channel = this.session.openChannel("exec");
        }
        catch (JSchException e) {
            this.disconnectChannel();
            throw new ServerSshException("Could not create channel for session");
        }
        return this.channel;
    }

    private void processResult(IProgressMonitor monitor) throws ServerSshException {
        while (!this.channel.isClosed()) {
            try {
                Thread.sleep(60L);
                if (monitor == null || !monitor.isCanceled()) continue;
                this.channel.disconnect();
                throw new ServerSshException("SSH operation canceled");
            }
            catch (InterruptedException e) {
                Activator.log("SSH Command interrupted by thread", e);
                Thread.currentThread().interrupt();
            }
        }
        this.channel.disconnect();
    }

    private int processExitCode() {
        int exitCode = this.channel.getExitStatus();
        if (exitCode != 0) {
            Activator.log(4, "SSH Command exited with exit code " + Integer.toString(exitCode));
        }
        return exitCode;
    }

    public void initializeSshCommand(String command, InputStream input, LimitedSizeStream output) throws ServerSshException {
        ((ChannelExec)this.channel).setCommand(command);
        this.channel.setInputStream(input);
        this.channel.setOutputStream((OutputStream)output);
        this.channel.setExtOutputStream((OutputStream)output);
        try {
            this.channel.connect(30000);
        }
        catch (JSchException e) {
            throw new ServerSshException("Could not connect to Channel");
        }
    }

    private int processSshCommand(String command, InputStream input, LimitedSizeStream output, IProgressMonitor monitor) throws ServerSshException {
        this.initializeSshCommand(command, input, output);
        this.processResult(monitor);
        return this.processExitCode();
    }

    public void initializeScpCommand(String command) throws ServerScpException {
        ((ChannelExec)this.channel).setCommand(command);
        this.initChannelScpStreams();
        try {
            this.channel.connect(3000);
        }
        catch (JSchException e) {
            throw new ServerScpException("Unable to create SCP channel");
        }
    }

    private void initChannelScpStreams() throws ServerScpException {
        try {
            this.output = this.channel.getOutputStream();
            this.input = this.channel.getInputStream();
        }
        catch (IOException e) {
            throw new ServerScpException("Unable to get SCP streams");
        }
    }

    @Override
    public <T> T runCmd(String command, IServerSsh.CommandHandler<T> handler, IProgressMonitor monitor) {
        StringBackend inputData = new StringBackend();
        LimitedSizeStream outputData = new LimitedSizeStream(0x100000);
        this.createChannel();
        int exitStatus = this.processSshCommand(command, inputData, outputData, monitor);
        return handler.handle(exitStatus, outputData);
    }

    @Override
    public <T> T runCmd(String command, IServerSsh.CommandHandler<T> handler) {
        return this.runCmd(command, handler, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean upload(String remoteFileName, File data, IProgressMonitor monitor) {
        FileSCP scpAction = new FileSCP(this);
        try {
            boolean success = scpAction.uploadFile(data, remoteFileName, monitor);
            return success;
        }
        catch (ServerScpException e) {
            return false;
        }
    }

    @Override
    public File download(String remoteFileName) throws ServerScpException {
        FileSCP scp = new FileSCP(this);
        return scp.fetchFile(remoteFileName);
    }
}

