/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.CollectServerInformation;
import com.excentis.products.byteblower.utils.ssh.steps.DownloadStep;
import com.excentis.products.byteblower.utils.ssh.steps.proxy.ProxyJobStep;
import java.util.IllegalFormatException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;

public class CheckVersionStep
extends UpgradeStep {
    private final IServerSsh ssh;

    public CheckVersionStep(IServerSsh ssh) {
        super("Checking ByteBlower Server version");
        this.ssh = ssh;
    }

    private Version getServerVersion(IProgressMonitor monitor) {
        return this.ssh.runCmd("byteblower-get-version", (exitCode, outputData) -> {
            Map<String, String> outputColons = this.parseNameValString(new String(outputData.get()), ":");
            String versionInfo = outputColons.getOrDefault("Version", Version.emptyVersion.toString());
            try {
                return Version.parseVersion((String)versionInfo);
            }
            catch (IllegalFormatException e) {
                return Version.emptyVersion;
            }
        }, monitor);
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        Version version = this.getServerVersion(monitor);
        if (version.compareTo(new Version(2, 11, 8)) >= 0) {
            return new CollectServerInformation(this.ssh);
        }
        if (version.compareTo(new Version(2, 9, 0)) >= 0) {
            return new DownloadStep(this.ssh);
        }
        if (version.compareTo(new Version(2, 5, 0)) >= 0) {
            return new ProxyJobStep(this.ssh);
        }
        if (version.compareTo(Version.emptyVersion) > 0) {
            String msg = String.format("The server runs version %s. This version is out of date and requires a manual update", version.toString());
            this.setError(msg);
            return NO_NEXT_STEP;
        }
        this.setError("No server version found. Is this a ByteBlower Server?");
        return NO_NEXT_STEP;
    }
}

