/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.RequestUpgradeArchive;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class CollectServerInformation
extends UpgradeStep {
    private final IServerSsh sshConnection;

    public CollectServerInformation(IServerSsh ssh) {
        super("Download Upgrade archive");
        this.sshConnection = ssh;
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        String cmd = "byteblower-update get-archive-info --json 2> /dev/null";
        String settingsTxt = this.retrieveSettings(monitor, "byteblower-update get-archive-info --json 2> /dev/null");
        Map<String, String> settings = this.convertJson(settingsTxt);
        if (RequestUpgradeArchive.checkValid(settings)) {
            settings = this.includeGUIInfo(monitor, settings);
            return new RequestUpgradeArchive(settings, this.sshConnection);
        }
        this.setError("Invalid ByteBlower server info. Stopping here.");
        return NO_NEXT_STEP;
    }

    private Map<String, String> convertJson(String settingsTxt) {
        Gson gson = new Gson();
        Type targetTep = new TypeToken<HashMap<String, String>>(){}.getType();
        Map result = Collections.emptyMap();
        try {
            Map parsed = (Map)gson.fromJson(settingsTxt, targetTep);
            if (parsed != null) {
                result = parsed;
            }
        }
        catch (JsonSyntaxException e) {
            this.setError("Mismatch communication ByteBlower Error");
        }
        return result;
    }

    private String retrieveSettings(IProgressMonitor monitor, String cmd) {
        monitor.subTask("Request info from the ByteBlower Server");
        String res = this.sshConnection.runCmd(cmd, (exitCode, outputData) -> new String(outputData.get()));
        return res;
    }

    private Map<String, String> includeGUIInfo(IProgressMonitor monitor, Map<String, String> settings) {
        settings.put("updater_proxy", "ByteBlower-GUI");
        return settings;
    }
}

