/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.FileHTTP;
import com.excentis.products.byteblower.utils.ssh.FileNativeHTTP;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.io.UpdateDownloadInfo;
import com.excentis.products.byteblower.utils.ssh.steps.ServerUploadStep;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class DownloadStep
extends UpgradeStep {
    private final IServerSsh ssh;

    public DownloadStep(IServerSsh serverSsh) {
        super("Downloading updates from the internet");
        this.ssh = serverSsh;
    }

    private UpdateDownloadInfo getDownloadInfo(IProgressMonitor monitor) {
        return this.ssh.runCmd("excentux-update get-archive-info", (exitCode, outputData) -> {
            Map<String, String> outputColons = this.parseNameValString(new String(outputData.get()), ":");
            String errorString = outputColons.getOrDefault("error", "");
            if (!errorString.equals("") && !errorString.equals("None")) {
                this.setError("Failed to obtain download info: " + errorString);
                return null;
            }
            if (exitCode != 0) {
                this.setError("Failed to obtain download info");
                return null;
            }
            String serverUsername = outputColons.getOrDefault("username", "");
            String serverPassword = outputColons.getOrDefault("password", "");
            String downloadLink = outputColons.getOrDefault("file", "");
            return new UpdateDownloadInfo(serverUsername, serverPassword, downloadLink);
        }, monitor);
    }

    private boolean checkFile(File archive) {
        try {
            return archive != null && Files.exists(archive.toPath(), new LinkOption[0]) && Files.size(archive.toPath()) > 0L;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        UpdateDownloadInfo info = this.getDownloadInfo(monitor);
        if (info == null) {
            return NO_NEXT_STEP;
        }
        try {
            File updateArchive = FileNativeHTTP.willUseProxy(info.getServerName()) ? FileNativeHTTP.download(info.getCredentials(), info.getServerName(), info.getDownloadLink(), monitor) : FileHTTP.download(info.getCredentialsProvider(), info.getServerName(), info.getDownloadLink(), monitor);
            if (this.checkFile(updateArchive)) {
                return new ServerUploadStep(this.ssh, updateArchive);
            }
            this.setError("Failed to download the update");
        }
        catch (HttpHostConnectException e) {
            this.setError("Failed to connect to the Update server");
        }
        catch (FileNativeHTTP.HttpException | HttpResponseException e) {
            this.setError("Failed to download Update archive " + e.getMessage());
        }
        catch (OperationCanceledException e) {
            this.setError("Download has been cancelled");
        }
        return NO_NEXT_STEP;
    }
}

