/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.FileHTTP;
import com.excentis.products.byteblower.utils.ssh.FileNativeHTTP;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.ServerUploadStep;
import java.io.File;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequestUpgradeArchive
extends UpgradeStep {
    private final IServerSsh ssh;
    private final Map<String, String> settings;

    public RequestUpgradeArchive(Map<String, String> settings, IServerSsh ssh) {
        super("Downloads the upgrade Archive");
        this.ssh = ssh;
        this.settings = settings;
    }

    static boolean checkValid(Map<String, String> settings) {
        return settings.containsKey("username") && settings.containsKey("password") && settings.containsKey("file");
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        if (!RequestUpgradeArchive.checkValid(this.settings)) {
            this.setError("Received invalid settings. Can't proceed update");
            return NO_NEXT_STEP;
        }
        String serverName = this.settings.get("username");
        String serverPass = this.settings.get("password");
        this.settings.remove("password");
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(serverName, serverPass);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        if (this.settings.containsKey("file")) {
            try {
                File upgradeArchive = FileNativeHTTP.willUseProxy(this.settings.get("file")) ? FileNativeHTTP.postDownload(credentials, serverName, this.settings.get("file"), monitor, this.settings) : FileHTTP.postDownload((CredentialsProvider)provider, serverName, this.settings.get("file"), monitor, this.settings);
                return new ServerUploadStep(this.ssh, upgradeArchive);
            }
            catch (HttpHostConnectException e) {
                String errorFmt = "Failed to connect to the upgrade server: %s";
                this.setError(String.format(errorFmt, e.getMessage()));
            }
            catch (FileNativeHTTP.HttpException | HttpResponseException e) {
                String errorFmt = "Failed to download the upgrade archive for the ByteBlower: %s";
                this.setError(String.format(errorFmt, e.getMessage()));
            }
        } else {
            this.setError("Missing update server from ByteBlower");
        }
        return null;
    }
}

