/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps;

import com.excentis.products.byteblower.utils.ssh.Activator;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.ServerUpgradeStep;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.runtime.IProgressMonitor;

public class ServerUploadStep
extends UpgradeStep {
    private static final String REMOTE_UPDATE_ARCHIVE = ".update_archive.bb";
    private final File uploadData;
    private final IServerSsh ssh;

    public ServerUploadStep(IServerSsh ssh, File uploadData) {
        super("Uploading updates to the ByteBlower server");
        this.ssh = ssh;
        this.uploadData = uploadData;
    }

    private void uploadToServer(IProgressMonitor monitor) {
        boolean success = this.ssh.upload(REMOTE_UPDATE_ARCHIVE, this.uploadData, monitor);
        if (!success) {
            this.setError("Error uploading upgrade to server");
        }
        try {
            Files.delete(this.uploadData.toPath());
        }
        catch (IOException e) {
            Activator.log("Delete of UpdateZip on local storage failed", e);
        }
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        this.uploadToServer(monitor);
        if (this.canProgress()) {
            return new ServerUpgradeStep(this.ssh, REMOTE_UPDATE_ARCHIVE);
        }
        return NO_NEXT_STEP;
    }
}

