/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils.ssh.steps.proxy;

import com.excentis.products.byteblower.utils.httpproxy.RequestListener;
import com.excentis.products.byteblower.utils.ssh.Activator;
import com.excentis.products.byteblower.utils.ssh.UpgradeStep;
import com.excentis.products.byteblower.utils.ssh.core.IServerSsh;
import com.excentis.products.byteblower.utils.ssh.steps.proxy.ProxyJobStep;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProxyUpgradeStep
extends UpgradeStep {
    private final RequestListener listener;
    private final ProxyJobStep jobStep;
    private final IServerSsh ssh;

    public ProxyUpgradeStep(IServerSsh ssh, ProxyJobStep jobStep) {
        super("Executing Proxy Server Upgrade");
        this.listener = jobStep.getListener();
        this.jobStep = jobStep;
        this.ssh = ssh;
    }

    private void doProxyUpgrade() {
        String cmd = String.format("excentux-update -q --proxy-server=`echo $SSH_CLIENT|cut -d \" \" -f 1`:%d upgrade", this.listener.getListenPort());
        String errorString = this.ssh.runCmd(cmd, (exitCode, outputData) -> {
            if (exitCode != 0) {
                String outputString = new String(outputData.get());
                Activator.log(4, "excentux-update failed: " + outputString);
                Map<String, String> outputColons = this.parseNameValString(outputString, ":");
                return outputColons.getOrDefault("Error", "");
            }
            return null;
        });
        if (errorString != null) {
            if (!errorString.equals("")) {
                this.setError(errorString);
            } else {
                this.setError("Unable to perform upgrade");
            }
            this.jobStep.cancel();
        }
    }

    @Override
    public UpgradeStep next(IProgressMonitor monitor) {
        this.doProxyUpgrade();
        return NO_NEXT_STEP;
    }
}

