/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DeviceIPv6InterfaceAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InetAddress address;
    private final int prefix;

    public DeviceIPv6InterfaceAddress(String address) throws UnknownHostException {
        String[] parts = address.split("/");
        if (parts.length == 2) {
            try {
                this.prefix = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ex) {
                throw new UnknownHostException(address);
            }
        } else if (parts.length == 1) {
            this.prefix = 1;
        } else {
            throw new UnknownHostException(address);
        }
        this.address = Inet6Address.getByName(parts[0]);
    }

    public boolean isAnyLocalAddress() {
        return this.address.isAnyLocalAddress();
    }

    public String getHostAddress() {
        return this.address.getHostAddress();
    }

    public boolean isLoopbackAddress() {
        return this.address.isLoopbackAddress();
    }

    public int prefixLength() {
        return this.prefix;
    }

    public String toString() {
        return String.valueOf(this.address.getHostAddress()) + "/" + this.prefix;
    }
}

