/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.utils;

import com.excentis.products.byteblower.utils.Cloneable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HighResolutionCalendar
extends GregorianCalendar
implements Cloneable {
    private static final long serialVersionUID = 20100305L;
    private static final Long SECONDS_IN_MINUTE = new Long(60L);
    private static final Long MINUTES_IN_HOUR = new Long(60L);
    private static final Long HR_IN_DAY = new Long(24L);
    private static final Long DAY_IN_WEEK = new Long(7L);
    public static final Double NANOSECONDS_IN_SECOND = new Double(1.0E9);
    private static final Long NANOSECONDS_IN_MILLISECOND = new Long(1000000L);
    private static final Long NANOSECONDS_IN_MICROSECOND = new Long(1000L);
    private static final Long THOUSAND = 1000L;
    private int[] highresFields = new int[2];
    public static final int MICROSECOND = 17;
    public static final int NANOSECOND = 18;
    private static final int HR_FIELD_COUNT = 19;

    public static HighResolutionCalendar MAX_VALUE() {
        return new HighResolutionCalendar(Long.MAX_VALUE);
    }

    public HighResolutionCalendar() {
        super(TimeZone.getTimeZone("GMT"));
        int i = 0;
        while (i < 2) {
            this.highresFields[i] = 0;
            ++i;
        }
        this.setTimeInNanoseconds(0L);
    }

    public HighResolutionCalendar(HighResolutionCalendar copy) {
        this(copy.getTimeInNanoseconds());
    }

    public HighResolutionCalendar(Long nanoseconds) {
        this();
        this.setTimeInNanoseconds(nanoseconds);
    }

    public HighResolutionCalendar(String nanoseconds) {
        this(new Long(nanoseconds));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream input = stream;
        input.defaultReadObject();
    }

    @Override
    public HighResolutionCalendar clone() {
        HighResolutionCalendar other = (HighResolutionCalendar)super.clone();
        other.highresFields = new int[2];
        int i = 0;
        while (i < 2) {
            other.highresFields[i] = this.highresFields[i];
            ++i;
        }
        return other;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HighResolutionCalendar other = (HighResolutionCalendar)obj;
        return Arrays.equals(this.highresFields, other.highresFields);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.highresFields);
        return result;
    }

    @Override
    public int compareTo(Calendar anotherCalendar) {
        if (anotherCalendar instanceof HighResolutionCalendar) {
            int comp = super.compareTo(anotherCalendar);
            return comp == 0 ? new Long(this.getTimeInNanoseconds()).compareTo(new Long(((HighResolutionCalendar)anotherCalendar).getTimeInNanoseconds())) : comp;
        }
        return super.compareTo(anotherCalendar);
    }

    @Override
    public String toString() {
        return Long.toString(this.getTimeInNanoseconds());
    }

    @Override
    public void set(int field, int value) {
        if (field < 17) {
            super.set(field, value);
        } else {
            this.highresFields[field - 17] = value;
        }
    }

    @Override
    public void add(int field, int amount) {
        if (field >= 19) {
            throw new IllegalArgumentException();
        }
        if (amount > 0) {
            if (field < 17) {
                super.add(field, amount);
            } else {
                long FIELDSIZE = 1000L;
                long totalValue = this.highresFields[field - 17] + amount;
                this.highresFields[field - 17] = (int)(totalValue % 1000L);
                this.add(field + 1, (int)(totalValue / 1000L));
            }
        }
    }

    @Override
    public int get(int field) {
        if (field == 17 || field == 18) {
            return this.highresFields[field - 17];
        }
        return super.get(field);
    }

    public int getMinute() {
        return this.get(12);
    }

    public int getSecond() {
        return this.get(13);
    }

    public int getMillisecond() {
        return this.get(14);
    }

    public int getMicrosecond() {
        return this.get(17);
    }

    public int getNanosecond() {
        return this.get(18);
    }

    public long getTimeInNanoseconds() {
        Long returnValue = this.getTimeInMillis();
        returnValue = returnValue * NANOSECONDS_IN_MILLISECOND;
        int microseconds = this.highresFields[0];
        int nanoseconds = this.highresFields[1];
        Long micros = Long.valueOf(microseconds) * NANOSECONDS_IN_MICROSECOND;
        Long nanos = nanoseconds;
        returnValue = returnValue + micros + nanos;
        return returnValue;
    }

    public void setTimeInNanoseconds(long nanoseconds) {
        long milliseconds = 0L;
        int microsecond = 0;
        int nanosecond = 0;
        if (nanoseconds != 0L) {
            Long nanosecondRemainder = nanoseconds % THOUSAND;
            nanosecond = nanosecondRemainder.intValue();
            Long longMicroseconds = nanoseconds / THOUSAND;
            if (longMicroseconds != 0L) {
                Long longMilliseconds = longMicroseconds / THOUSAND;
                Long longMicrosecondRemainder = longMicroseconds % THOUSAND;
                microsecond = longMicrosecondRemainder.intValue();
                milliseconds = longMilliseconds;
            }
        }
        this.setTimeInMillis(milliseconds);
        this.set(17, microsecond);
        this.set(18, nanosecond);
    }

    @Override
    public void setTimeInMillis(long millis) {
        super.setTimeInMillis(millis);
        if (this.highresFields != null) {
            int i = 0;
            while (i < 2) {
                this.highresFields[i] = 0;
                ++i;
            }
        }
    }

    public HighResolutionCalendar addRelative(HighResolutionCalendar add) {
        Long nanos = this.getTimeInNanoseconds();
        nanos = nanos + add.getTimeInNanoseconds();
        return new HighResolutionCalendar(nanos);
    }

    public HighResolutionCalendar subtractRelative(HighResolutionCalendar subtract) {
        Long nanos = this.getTimeInNanoseconds();
        nanos = nanos - subtract.getTimeInNanoseconds();
        return new HighResolutionCalendar(nanos);
    }

    int getTotal(int field) {
        Long result = this.getTimeInNanoseconds();
        switch (field) {
            case 4: {
                result = result / DAY_IN_WEEK;
            }
            case 7: {
                result = result / HR_IN_DAY;
            }
            case 10: {
                result = result / MINUTES_IN_HOUR;
            }
            case 12: {
                result = result / SECONDS_IN_MINUTE;
            }
            case 13: {
                result = result / THOUSAND;
            }
            case 14: {
                result = result / THOUSAND;
            }
            case 17: {
                result = result / THOUSAND;
            }
            case 18: {
                break;
            }
            default: {
                System.out.println("HighResolutionCalendar getTotal : unknown field : " + field);
            }
        }
        return result.intValue();
    }
}

