/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller;

import com.excentis.products.byteblower.bear.controller.commands.CreateBearListenerCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearRootCommand;
import com.excentis.products.byteblower.bear.controller.commands.RemoveBearJobCommand;
import com.excentis.products.byteblower.bear.controller.commands.RemoveBearListenerCommand;
import com.excentis.products.byteblower.bear.controller.jobs.ForceCleanupScenario;
import com.excentis.products.byteblower.bear.controller.jobs.InitializeScenarioJob;
import com.excentis.products.byteblower.bear.controller.jobs.OpenFileProjectJob;
import com.excentis.products.byteblower.bear.controller.jobs.OpenXmlProjectJob;
import com.excentis.products.byteblower.bear.controller.jobs.RunScenarioJob;
import com.excentis.products.byteblower.bear.controller.jobs.RuntimeBearJob;
import com.excentis.products.byteblower.bear.feedback.id.BearId;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.listener.IBearListener;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.listener.BearModelChangeListener;
import com.excentis.products.byteblower.bear.model.bear.BearListener;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.reader.BearReader;
import com.excentis.products.byteblower.datapersistence.hook.EventHook;
import com.excentis.products.byteblower.datapersistence.hook.EventHookFactory;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class BearController {
    private static BearController instance = null;
    private static final String BEAR_RESOURCE_FILE_EXTENSION = "bear";
    private static final Logger LOGGER = Logger.getGlobal();
    private final TransactionalEditingDomain bearDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
    private final Resource bearResource;
    private final Map<BearScenarioId, RuntimeScenarioRunner> runners;

    private BearController() {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map extensionFactoryMap = reg.getExtensionToFactoryMap();
        extensionFactoryMap.put(BEAR_RESOURCE_FILE_EXTENSION, new XMIResourceFactoryImpl());
        String bearUri = "bear_uri.bear";
        this.bearResource = this.bearDomain.createResource(bearUri);
        this.bearDomain.addResourceSetListener((ResourceSetListener)new BearModelChangeListener());
        this.runners = new ConcurrentHashMap<BearScenarioId, RuntimeScenarioRunner>();
    }

    public static synchronized BearController getInstance() {
        if (instance == null) {
            instance = new BearController();
        }
        return instance;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.bearDomain;
    }

    public Resource getBearResource() {
        return this.bearResource;
    }

    public void openFileProject(BearProjectId projectId, String filename) {
        OpenFileProjectJob job = new OpenFileProjectJob(filename, projectId);
        job.schedule();
    }

    public void openXmlProject(BearProjectId projectId, String xmlProject) {
        OpenXmlProjectJob job = new OpenXmlProjectJob(xmlProject, projectId);
        job.schedule();
    }

    public void initializeScenario(BearProjectId projectId, final BearScenarioId scenarioId, String scenarioName, String runTitle) {
        RuntimeScenarioRunner rtScenariorunner = new RuntimeScenarioRunner();
        ArrayList<EventHook> eventHooks = new ArrayList<EventHook>();
        eventHooks.add(EventHookFactory.createHook((EventHookFactory.Type)EventHookFactory.Type.LOG_DEBUG));
        eventHooks.add(EventHookFactory.createHook((EventHookFactory.Type)EventHookFactory.Type.DATAGATHERING_H2));
        this.runners.put(scenarioId, rtScenariorunner);
        InitializeScenarioJob job = new InitializeScenarioJob(projectId, scenarioId, scenarioName, runTitle, rtScenariorunner, eventHooks);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (BearController.this.getBearReader().getBearScenarioStatus(scenarioId) == EBearScenarioStatus.ERROR || BearController.this.getBearReader().getBearScenarioStatus(scenarioId) == EBearScenarioStatus.CANCELED) {
                    BearController.this.runners.remove(scenarioId);
                }
            }
        });
        job.schedule();
    }

    public void runScenario(final BearScenarioId scenarioId) {
        RuntimeScenarioRunner runner = this.runners.get(scenarioId);
        if (runner == null) {
            throw new IllegalStateException("No scenario runner found for scenario ID " + scenarioId);
        }
        RunScenarioJob job = new RunScenarioJob(scenarioId, runner);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                BearController.this.runners.remove(scenarioId);
            }
        });
        job.schedule();
    }

    public void forceCleanupScenario(final BearScenarioId scenarioId) {
        RuntimeScenarioRunner runner = this.runners.get(scenarioId);
        if (runner == null) {
            LOGGER.info("Can't clean. Scenario not started, or already stopped");
            return;
        }
        ForceCleanupScenario job = new ForceCleanupScenario(scenarioId, runner);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                BearController.this.runners.remove(scenarioId);
            }
        });
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) {
        TransactionalCommandStack stack = (TransactionalCommandStack)this.bearDomain.getCommandStack();
        BearController bearController = instance;
        synchronized (bearController) {
            if (command != null && command.canExecute()) {
                try {
                    stack.execute(command, Collections.emptyMap());
                    stack.flush();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "BearController::execute : caught InterruptedException ", e);
                    Thread.currentThread().interrupt();
                }
                catch (RollbackException e) {
                    LOGGER.log(Level.WARNING, "BearController::execute : caught RollbackException", e);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "BearController::execute : caught Exception", e);
                }
            }
        }
    }

    public BearRoot getBearRoot() {
        BearRoot bearRoot = this.getBearReader().getBearRoot();
        if (bearRoot == null) {
            CreateBearRootCommand command = new CreateBearRootCommand();
            this.execute((Command)command);
            bearRoot = command.getBearRoot();
        }
        return bearRoot;
    }

    private BearReader getBearReader() {
        return BearReader.getInstance();
    }

    public void addBearListener(IBearListener bearListener) {
        CreateBearListenerCommand command = new CreateBearListenerCommand(this.getBearRoot(), bearListener);
        this.execute((Command)command);
    }

    public void removeBearListener(IBearListener externalBearListener) {
        for (BearListener bearListener : this.getBearRoot().getListeners()) {
            if (bearListener.getExternalListener() != externalBearListener) continue;
            RemoveBearListenerCommand command = new RemoveBearListenerCommand(this.getBearRoot(), bearListener);
            BearAsyncExec remove = new BearAsyncExec(command);
            remove.schedule();
            return;
        }
    }

    public void removeJob(RuntimeBearJob runtimeBearJob) {
        RemoveBearJobCommand command = new RemoveBearJobCommand(this.getBearRoot(), runtimeBearJob.getBearJob());
        this.execute((Command)command);
    }

    public void cancelJob(BearId bearId) {
        BearReader bearReader = this.getBearReader();
        Job job = bearReader.getJob(bearId);
        if (job != null) {
            job.cancel();
        }
    }

    public void notifyBearListeners(Notification notification) {
        BearReader bearReader = this.getBearReader();
        EList<BearListener> listeners = bearReader.getBearListeners();
        for (BearListener bearListener : listeners) {
            IBearListener externalListener = bearReader.getExternalListener(bearListener);
            externalListener.onBearModelNotification(notification);
        }
    }

    public BearController clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("BearController singleton cannot be cloned");
    }

    private class BearAsyncExec
    extends Job {
        private final RemoveBearListenerCommand command;

        public BearAsyncExec(RemoveBearListenerCommand command) {
            super("Bear async command execution");
            this.command = command;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            BearController.this.execute((Command)this.command);
            if (monitor != null) {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

