/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.commands;

import com.excentis.products.byteblower.bear.controller.BearController;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.model.bear.BearProject;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public abstract class BearRecordingCommand
extends RecordingCommand {
    private static final Object lock = new Object();
    private static boolean executing = false;
    private static final Logger LOGGER = Logger.getGlobal();

    public BearRecordingCommand() {
        super(BearRecordingCommand.getEditingDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        Object object = lock;
        synchronized (object) {
            try {
                if (executing) {
                    LOGGER.warning("!!! WARNING !!! Nested RecordingCommand !!!");
                }
                executing = true;
                this.doBearExecute();
            }
            finally {
                executing = false;
            }
        }
    }

    protected abstract void doBearExecute();

    protected BearRoot getBearRoot() {
        return BearRecordingCommand.getBearController().getBearRoot();
    }

    private static BearController getBearController() {
        return BearController.getInstance();
    }

    private static TransactionalEditingDomain getEditingDomain() {
        return BearRecordingCommand.getBearController().getEditingDomain();
    }

    protected Resource getBearResource() {
        return BearRecordingCommand.getBearController().getBearResource();
    }

    protected BearProject getBearProject(BearProjectId bearProjectId) {
        for (BearProject bearProject : this.getBearRoot().getProjects()) {
            if (!bearProject.getBearProjectId().equals((Object)bearProjectId)) continue;
            return bearProject;
        }
        return null;
    }
}

