/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.controller.jobs;

import com.excentis.products.byteblower.bear.controller.commands.BearRecordingCommand;
import com.excentis.products.byteblower.bear.controller.commands.BearSetCommand;
import com.excentis.products.byteblower.bear.controller.commands.BearSetScenarioStatusCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearScenarioCommand;
import com.excentis.products.byteblower.bear.controller.commands.CreateBearScenarioInitializationJobCommand;
import com.excentis.products.byteblower.bear.controller.jobs.RuntimeBearJob;
import com.excentis.products.byteblower.bear.feedback.id.BearProjectId;
import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.bear.feedback.status.EBearScenarioStatus;
import com.excentis.products.byteblower.bear.model.bear.BearPackage;
import com.excentis.products.byteblower.bear.model.bear.BearRoot;
import com.excentis.products.byteblower.bear.model.bear.BearScenario;
import com.excentis.products.byteblower.bear.model.bear.EBearJobStatus;
import com.excentis.products.byteblower.datapersistence.hook.EventHook;
import com.excentis.products.byteblower.datapersistence.hook.PersistenceEventHook;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.core.CancellationTriggered;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class InitializeScenarioJob
extends RuntimeBearJob {
    private static final int EVENTHOOK_WORK = 2;
    private static final int EVENTHOOK_WORK_PERSISTENCE = 8;
    private final BearProjectId projectId;
    private final BearScenarioId scenarioId;
    private final String scenarioName;
    private final RuntimeScenarioRunner rtScenarioRunner;
    private final List<EventHook> eventHooks;
    private final BearScenario bearScenario;
    private String runTitle;

    public InitializeScenarioJob(BearProjectId projectId, BearScenarioId scenarioId, String scenarioName, String runTitle, RuntimeScenarioRunner rtScenarioRunner, List<EventHook> eventHooks) {
        super("Initialize scenario " + scenarioName);
        this.projectId = projectId;
        this.scenarioId = scenarioId;
        this.scenarioName = scenarioName;
        this.runTitle = runTitle;
        this.rtScenarioRunner = rtScenarioRunner;
        this.eventHooks = eventHooks;
        BearRoot bearRoot = this.getBearRoot();
        CreateBearScenarioCommand command = new CreateBearScenarioCommand(projectId, scenarioId);
        this.execute(command);
        this.bearScenario = command.getBearScenario();
        CreateBearScenarioInitializationJobCommand jobCommand = new CreateBearScenarioInitializationJobCommand(bearRoot, this.bearScenario, this);
        this.execute(jobCommand);
        this.bearJob = jobCommand.getBearJob();
        this.setJobStatus(EBearJobStatus.INITIALIZED);
    }

    @Override
    protected void work(IProgressMonitor progressMonitor) {
        try {
            Scenario mScenario = this.getBearReader().getScenario(this.projectId, this.scenarioName);
            if (mScenario == null) {
                throw new IllegalStateException("Cannot find scenario named '" + this.scenarioName + "' in runtime project with ID " + this.projectId.getId());
            }
            progressMonitor.beginTask("Initialize scenario", this.calculateScenarioInitializationWork(ReaderFactory.create((Scenario)mScenario)));
            progressMonitor.subTask("Apply datagathering hooks");
            for (EventHook eventHook : this.eventHooks) {
                eventHook.attach(this.scenarioId, this.rtScenarioRunner);
                progressMonitor.worked(2);
                if (!(eventHook instanceof PersistenceEventHook)) continue;
                progressMonitor.worked(8);
                PersistenceEventHook persistenceEventHook = (PersistenceEventHook)eventHook;
                Long persistenceId = persistenceEventHook.getTestDataPersistenceId();
                this.setScenarioPersistenceId(persistenceId);
            }
            this.setScenarioStatus(EBearScenarioStatus.PERSISTENCE_HOOKED);
            this.setScenarioStatus(EBearScenarioStatus.INITIALIZING);
            this.rtScenarioRunner.initialize(mScenario, this.runTitle, progressMonitor);
            this.setScenarioStatus(EBearScenarioStatus.INITIALIZED);
        }
        catch (CancellationTriggered e) {
            this.setScenarioStatus(EBearScenarioStatus.CANCELED);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.SEVERE, "Could not initialize scenario", e);
            this.storeException(e);
            this.setScenarioStatus(EBearScenarioStatus.ERROR);
        }
    }

    private void storeException(final Throwable e) {
        BearRecordingCommand command = new BearRecordingCommand(){

            @Override
            protected void doBearExecute() {
                InitializeScenarioJob.this.bearScenario.setException((Exception)e);
            }
        };
        this.execute(command);
    }

    private void setScenarioStatus(EBearScenarioStatus status) {
        BearSetScenarioStatusCommand command = new BearSetScenarioStatusCommand(this.bearScenario, status);
        this.execute(command);
    }

    private void setScenarioPersistenceId(Long persistenceId) {
        BearSetCommand cmd = new BearSetCommand((EObject)this.bearScenario, (EStructuralFeature)BearPackage.Literals.BEAR_SCENARIO__TEST_DATA_PERSISTENCE_ID, persistenceId);
        this.execute(cmd);
    }

    private int calculateScenarioInitializationWork(ScenarioReader mScenarioReader) {
        int work = 0;
        for (EventHook eventHook : this.eventHooks) {
            work += 2;
            if (!(eventHook instanceof PersistenceEventHook)) continue;
            work += 8;
        }
        work += mScenarioReader.getInvolvedServers().size() * 5;
        work += mScenarioReader.getInvolvedPorts().size() * 3;
        work += mScenarioReader.getFlowMeasurements().size() * 3;
        return work += 5;
    }
}

