/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.operations.impl.core;

import com.excentis.products.byteblower.bear.operations.CancelableOperation;
import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.bear.operations.impl.core.OperationCancelTrigger;
import com.excentis.products.byteblower.bear.operations.impl.core.OperationReturnedTrigger;

abstract class BaseCancelableOperation<ReturnType>
implements CancelableOperation,
OperationReturnedTrigger<ReturnType>,
OperationCancelTrigger {
    private final Object lockObject = new Object();
    protected Status status = Status.CREATED;
    private Operation.Callback<ReturnType> callback = null;
    private CancelableOperation.Callback cancelCallback = null;

    public BaseCancelableOperation(Operation.Callback<ReturnType> callback, CancelableOperation.Callback cancelCallback) {
        this.callback = callback;
        this.cancelCallback = cancelCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Operation.IsRunningException, Operation.HasRunnedException {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case CREATED: {
                    this.status = Status.RUNNING;
                    break;
                }
                case RUNNING: 
                case RUNNING_CANCELREQ: {
                    throw new Operation.IsRunningException();
                }
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new Operation.HasRunnedException();
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
        }
        try {
            this.performImpl();
        }
        catch (Exception t) {
            this.triggerError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws CancelableOperation.NotRunningException {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING: {
                    this.status = Status.RUNNING_CANCELREQ;
                    break;
                }
                case RUNNING_CANCELREQ: {
                    break;
                }
                case CREATED: 
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new CancelableOperation.NotRunningException();
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
        }
        try {
            this.cancelRequestImpl();
        }
        catch (Exception t) {
            this.triggerError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerFinished(ReturnType returnValue) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING_CANCELREQ: {
                    if (this.cancelCallback != null) {
                        this.cancelCallback.cancelFailed();
                    }
                }
                case RUNNING: {
                    this.status = Status.DONE;
                    break;
                }
                case CREATED: 
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected onFinish BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.callback != null) {
                this.callback.done(returnValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerError(Exception t) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING_CANCELREQ: {
                    if (this.cancelCallback != null) {
                        this.cancelCallback.cancelFailed();
                    }
                }
                case RUNNING: {
                    this.status = Status.ERROR;
                    break;
                }
                case CREATED: 
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected onError BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.callback != null) {
                this.callback.failed(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerCancelHandled() {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING: 
                case RUNNING_CANCELREQ: {
                    this.status = Status.CANCELED;
                    break;
                }
                case CREATED: 
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected notifyCancelled BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.cancelCallback != null) {
                this.cancelCallback.canceled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerCancelIgnored() {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING: 
                case RUNNING_CANCELREQ: {
                    this.status = Status.RUNNING;
                    break;
                }
                case CREATED: 
                case DONE: 
                case CANCELED: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected notifyCancelled BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.cancelCallback != null) {
                this.cancelCallback.cancelFailed();
            }
        }
    }

    protected abstract void performImpl() throws Exception;

    protected abstract void cancelRequestImpl() throws Exception;

    protected static enum Status {
        CREATED,
        RUNNING,
        RUNNING_CANCELREQ,
        DONE,
        CANCELED,
        ERROR;

    }
}

