/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.bear.operations.impl.core;

import com.excentis.products.byteblower.bear.operations.Operation;
import com.excentis.products.byteblower.bear.operations.impl.core.OperationReturnedTrigger;

public abstract class BaseOperation<ReturnType>
implements Operation,
OperationReturnedTrigger<ReturnType> {
    private final Object lockObject = new Object();
    public Status status = Status.CREATED;
    private Operation.Callback<ReturnType> callback = null;

    public BaseOperation(Operation.Callback<ReturnType> callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws Operation.IsRunningException, Operation.HasRunnedException {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case CREATED: {
                    this.status = Status.RUNNING;
                    break;
                }
                case RUNNING: {
                    throw new Operation.IsRunningException();
                }
                case DONE: 
                case ERROR: {
                    throw new Operation.HasRunnedException();
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
        }
        try {
            this.performImpl();
        }
        catch (Exception t) {
            this.triggerError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerFinished(ReturnType returnValue) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING: {
                    this.status = Status.DONE;
                    break;
                }
                case CREATED: 
                case DONE: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected onFinish BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.callback != null) {
                this.callback.done(returnValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerError(Exception t) {
        Object object = this.lockObject;
        synchronized (object) {
            switch (this.status) {
                case RUNNING: {
                    this.status = Status.ERROR;
                    break;
                }
                case CREATED: 
                case DONE: 
                case ERROR: {
                    throw new IllegalStateException("Unexpected onError BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
                default: {
                    throw new IllegalStateException("Unknown BEAR operation state '" + (Object)((Object)this.status) + "'");
                }
            }
            if (this.callback != null) {
                this.callback.failed(t);
            }
        }
    }

    protected abstract void performImpl() throws Exception;

    protected static enum Status {
        CREATED,
        RUNNING,
        DONE,
        ERROR;

    }
}

