/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.clt;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.regex.Pattern;

class InputValidationApiKey {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !InputValidationApiKey.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !InputValidationApiKey.allowedCloudUrlArgument("https://dev.cloud.excentis.com")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !InputValidationApiKey.allowedCloudUrlArgument("https://dev.cloud.excentis.com#gui")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !InputValidationApiKey.allowedCloudUrlArgument("https://dev.cloud.excentis.com#?gui=true")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !InputValidationApiKey.allowedCloudUrlArgument("https://cloud.excentis.com")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !InputValidationApiKey.allowedCloudUrlArgument("https://cloud.excentis.com/gui/test/")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && InputValidationApiKey.allowedCloudUrlArgument("http://cloud.excentis.com/gui/test/")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && InputValidationApiKey.allowedCloudUrlArgument("/etc/passwd/")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && InputValidationApiKey.allowedCloudUrlArgument("mailto:/etc/passwd/")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && InputValidationApiKey.allowedCloudUrlArgument("C:\\")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !InputValidationApiKey.allowedApiKey("da19fe53-4a4e-4c9a-b0f8-698ff2e921dc")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && InputValidationApiKey.allowedApiKey("\ud83d\ude2d")) {
            throw new AssertionError();
        }
    }

    InputValidationApiKey() {
    }

    public static boolean allowedCloudUrlArgument(String url) {
        String start = Pattern.quote("https://");
        String urlPattern = String.valueOf(start) + "[a-zA-Z0-9#-_/?=]{1,256}";
        return Pattern.matches(urlPattern, url);
    }

    public static boolean allowedApikeyFile(String filePath) {
        try {
            Paths.get(filePath, new String[0]);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    public static boolean allowedApiKey(String key) {
        String pattern = "[a-z,A-Z,0-9,_,-]{1,200}";
        return Pattern.matches(pattern, key);
    }
}

