/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datalibs;

import com.excentis.products.byteblower.datalibs.DatabaseConfiguration;
import com.excentis.products.byteblower.datalibs.DatabaseModifier;
import com.excentis.products.byteblower.datalibs.DatabaseTypeCustomization;
import com.excentis.products.byteblower.datalibs.ScriptRunner;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.jdbc.JdbcSQLException;

public class DatabaseGenerator {
    private static final Logger LOGGER = Logger.getGlobal();
    private final DatabaseConfiguration config;

    public DatabaseGenerator(DatabaseConfiguration config) {
        this.config = config;
    }

    public void performDatabaseGeneration(String sqlScript, DatabaseModifier modifier) {
        try {
            this.runScipt(sqlScript, modifier);
        }
        catch (Exception e) {
            throw new DatabaseException("Failed to generate/update result_metadata " + this.config + " persistence due to following error:\n" + e, e);
        }
    }

    private void runScipt(String sqlScript, DatabaseModifier modifier) throws IOException, SQLException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = DriverManager.getConnection(this.config.getUrl(), "byteblower", "excentis");){
                String dbSpecificScript = DatabaseTypeCustomization.customize(this.config.getType(), sqlScript, this.config.getName());
                ScriptRunner sr = new ScriptRunner(conn, false, true);
                sr.setLogWriter(null);
                sr.runScript(new StringReader(dbSpecificScript));
                if (!modifier.doUpdate(conn, this.config.getType())) {
                    LOGGER.log(Level.SEVERE, "Was not able to modify the database");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JdbcSQLException h2Exception) {
            LOGGER.log(Level.SEVERE, "H2 Exception - ", h2Exception);
        }
    }

    private static class DatabaseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private DatabaseException(String description, Exception source) {
            super(description, source);
        }
    }
}

