/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.hook.impl;

import com.excentis.products.byteblower.bear.feedback.id.BearScenarioId;
import com.excentis.products.byteblower.datapersistence.hook.PersistenceEventHook;
import com.excentis.products.byteblower.datapersistence.listeners.AddressResolutionHandle;
import com.excentis.products.byteblower.datapersistence.listeners.DebugCollector;
import com.excentis.products.byteblower.datapersistence.listeners.FbFlowHandle;
import com.excentis.products.byteblower.datapersistence.listeners.GatherWifiStats;
import com.excentis.products.byteblower.datapersistence.listeners.HttpFlowHandle;
import com.excentis.products.byteblower.datapersistence.listeners.MissingSnapshotsCheck;
import com.excentis.products.byteblower.datapersistence.listeners.NatDiscoveryHandle;
import com.excentis.products.byteblower.datapersistence.listeners.PortHandle;
import com.excentis.products.byteblower.datapersistence.listeners.ServersOutOfSync;
import com.excentis.products.byteblower.datapersistence.listeners.TestProgressHandle;
import com.excentis.products.byteblower.datapersistence.listeners.ThroughputTestHandle;
import com.excentis.products.byteblower.results.dataprovider.data.BaseEntityManager;
import com.excentis.products.byteblower.results.dataprovider.data.MetaDataPersistenceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.dataprovider.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.dataprovider.data.enums.PersistenceType;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceType;
import com.excentis.products.byteblower.run.RuntimeScenarioRunner;
import com.excentis.products.byteblower.run.actions.CleanupScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;

abstract class RuntimeDatagatheringHook
implements PersistenceEventHook,
CleanupScenario.Listener {
    private final TestDataPersistenceType testDataPersistenceType;
    private Long testDataPersistenceId = null;
    private MetaDataPersistenceController mdpc = null;
    private TestDataPersistenceController tdpc = null;

    RuntimeDatagatheringHook(TestDataPersistenceType tdpt) {
        this.testDataPersistenceType = tdpt;
    }

    @Override
    public Long getTestDataPersistenceId() {
        return this.testDataPersistenceId;
    }

    @Override
    public void attach(BearScenarioId scenarioId, RuntimeScenarioRunner rtScenarioRunner) {
        this.mdpc = MetaDataPersistenceController.getInstance();
        this.mdpc.forceInitialize();
        TestDataReference tdr = new TestDataReference();
        this.persistTestDataReference(tdr, this.mdpc);
        if (tdr.getId() == null) {
            throw new IllegalStateException("TestDataReference entity should have valid testId after persisting.");
        }
        this.testDataPersistenceId = tdr.getId();
        this.tdpc = TestDataPersistenceController.getInstance((Long)this.testDataPersistenceId);
        tdr.setPersistenceType(this.convertTestDataPersistenceType(this.testDataPersistenceType));
        tdr.setPersistenceUrl(this.tdpc.getPersistenceUrl());
        this.persistTestDataReference(tdr, this.mdpc);
        Context context = rtScenarioRunner.getContext();
        new TestProgressHandle(this.tdpc, this.mdpc, tdr).register(context);
        new PortHandle(this.tdpc).register(context);
        new FbFlowHandle(this.tdpc).register(context);
        new HttpFlowHandle(this.tdpc).register(context);
        new NatDiscoveryHandle(this.tdpc).register(context);
        new AddressResolutionHandle(this.tdpc).register(context);
        new ServersOutOfSync(this.tdpc).register(context);
        new ThroughputTestHandle(this.tdpc).register(context);
        new MissingSnapshotsCheck(this.tdpc).register(context);
        new DebugCollector(this.tdpc).register(context);
        new GatherWifiStats(this.tdpc).register(context);
    }

    @Override
    public void detach() {
    }

    public void onScenarioCleanedUp(RuntimeScenario rtScenario) {
    }

    public void onScenarioCleanupFailed(RuntimeScenario rtScenario, String errorMessage) {
    }

    private void persistTestDataReference(TestDataReference tdr, MetaDataPersistenceController mdpc) {
        BaseEntityManager tdrm = new BaseEntityManager(TestDataReference.class, mdpc);
        tdrm.persistIdEntity((BaseEntity)tdr);
    }

    private PersistenceType convertTestDataPersistenceType(TestDataPersistenceType tdPersistencyType) {
        switch (tdPersistencyType) {
            case MYSQL: {
                return PersistenceType.MYSQL;
            }
            case H2: {
                return PersistenceType.H2;
            }
        }
        throw new IllegalArgumentException("Failed to apply RuntimeDataGatheringHook: unknown persistence type " + tdPersistencyType);
    }
}

