/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.results.testdata.data.AddressResolutionManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv4AddressManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv6AddressManager;
import com.excentis.products.byteblower.results.testdata.data.MacAddressManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv4Event;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.AddressResolutionIpv6Event;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.MacAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.run.actions.ResolveMacAddress;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import java.util.Date;

public class AddressResolutionHandle
extends BaseHandle
implements ResolveMacAddress.Listener {
    private final EventManager eventManager;
    private final Ipv4AddressManager ipv4AddressManager;
    private final Ipv6AddressManager ipv6AddressManager;
    private final MacAddressManager macAddressManager;
    private final ScenarioManager scenarioManager;
    private final PortManager portManager;
    private final AddressResolutionManager addressResolutionManager;

    public AddressResolutionHandle(TestDataPersistenceController pc) {
        super(pc);
        this.eventManager = new EventManager(pc);
        this.ipv4AddressManager = new Ipv4AddressManager(pc);
        this.ipv6AddressManager = new Ipv6AddressManager(pc);
        this.macAddressManager = new MacAddressManager(pc);
        this.scenarioManager = new ScenarioManager(pc);
        this.portManager = new PortManager(pc);
        this.addressResolutionManager = new AddressResolutionManager(pc);
    }

    @Override
    public void register(Context context) {
        context.listen(ResolveMacAddress.Listener.class, (Object)this);
    }

    public void onMacAddressResolved(RuntimePort rtPortResolver, String ipAddressString, String macAddressString) {
        this.handleNewAddressResolution(new Date(), rtPortResolver, ipAddressString, macAddressString);
    }

    public void onMacAddressResolveFailed(RuntimePort rtPortResolver, String ipAddressString) {
        this.handleNewAddressResolution(new Date(), rtPortResolver, ipAddressString, null);
    }

    private void handleNewAddressResolution(Date time, RuntimePort rtPortResolver, String ipAddressString, String macAddressString) {
        EventSeverity severity;
        String message;
        String scenarioName = rtPortResolver.getRuntimeScenario().getName();
        String resolverPortName = rtPortResolver.getName();
        Scenario scenario = this.scenarioManager.find(scenarioName);
        Port resolverPort = this.portManager.find(resolverPortName);
        MacAddress resolvedMacAddress = macAddressString == null ? null : this.macAddressManager.findOrCreate(macAddressString);
        if (resolvedMacAddress == null) {
            message = "Address resolution by resolver '" + resolverPortName + "' for IP " + ipAddressString + " failed.";
            severity = EventSeverity.NETWORK_WARNING;
        } else {
            message = "Address resolution by resolver '" + resolverPortName + "' for IP " + ipAddressString + " returned MAC address " + macAddressString + ".";
            severity = EventSeverity.NETWORK_LOG;
        }
        if (rtPortResolver.isRuntimeLayer3Ipv4()) {
            Ipv4Address ipv4Address = this.ipv4AddressManager.findOrCreate(ipAddressString);
            AddressResolutionIpv4 addressResolutionIpv4 = this.addressResolutionManager.createOrUpdate(scenario, resolverPort, ipv4Address, resolvedMacAddress);
            AddressResolutionIpv4Event event = new AddressResolutionIpv4Event(time, message, severity, addressResolutionIpv4);
            this.eventManager.persistIdEntity((BaseEntity)event);
        } else if (rtPortResolver.isRuntimeLayer3Ipv6()) {
            Ipv6Address ipv6Address = this.ipv6AddressManager.findOrCreate(ipAddressString);
            AddressResolutionIpv6 addressResolutionIpv6 = this.addressResolutionManager.createOrUpdate(scenario, resolverPort, ipv6Address, resolvedMacAddress);
            AddressResolutionIpv6Event event = new AddressResolutionIpv6Event(time, message, severity, addressResolutionIpv6);
            this.eventManager.persistIdEntity((BaseEntity)event);
        }
    }
}

