/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.communication.api.Stream;
import com.excentis.products.byteblower.communication.api.StreamMobile;
import com.excentis.products.byteblower.communication.api.StreamResultHistory;
import com.excentis.products.byteblower.communication.api.StreamRuntimeStatus;
import com.excentis.products.byteblower.datapersistence.listeners.BaseHandle;
import com.excentis.products.byteblower.datapersistence.listeners.StoreIntervalSnapshots;
import com.excentis.products.byteblower.datapersistence.util.FrameBlastingUtils;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv4MulticastMemberPort;
import com.excentis.products.byteblower.model.Ipv6MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastFilterType;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.MulticastMemberPort;
import com.excentis.products.byteblower.model.MulticastSourceByteBlowerGuiPort;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.reader.FlowMeasurementReader;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.IpAddressReaderImpl;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv4AddressManager;
import com.excentis.products.byteblower.results.testdata.data.Ipv6AddressManager;
import com.excentis.products.byteblower.results.testdata.data.MulticastConfigurationManager;
import com.excentis.products.byteblower.results.testdata.data.MulticastSourceGroupManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigMulticast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigUnicast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastConfigurationIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastConfigurationIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastMember;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastMemberSsm;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastSource;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourcePort;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.core.BaseEntity;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import com.excentis.products.byteblower.results.testdata.data.enums.FlowInstanceStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.MulticastProtocol;
import com.excentis.products.byteblower.results.testdata.data.enums.MulticastSourceFilterType;
import com.excentis.products.byteblower.run.actions.ConfigureFlow;
import com.excentis.products.byteblower.run.actions.ConfigureFlowTrafficFb;
import com.excentis.products.byteblower.run.actions.ConfigureFlows;
import com.excentis.products.byteblower.run.actions.CreateFlow;
import com.excentis.products.byteblower.run.actions.CreateFlows;
import com.excentis.products.byteblower.run.actions.CreateFrame;
import com.excentis.products.byteblower.run.actions.ImproveFilters;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimeFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFixedDestination;
import com.excentis.products.byteblower.run.objects.RuntimeFlow;
import com.excentis.products.byteblower.run.objects.RuntimeFlowDestination;
import com.excentis.products.byteblower.run.objects.RuntimeFlowSource;
import com.excentis.products.byteblower.run.objects.RuntimeFrame;
import com.excentis.products.byteblower.run.objects.RuntimeGroupFbFlow;
import com.excentis.products.byteblower.run.objects.RuntimeInterface;
import com.excentis.products.byteblower.run.objects.RuntimeMulticastDestination;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimePortDestination;
import com.excentis.products.byteblower.run.objects.RuntimeRx;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalLatencyDistributionSnapshot;
import com.excentis.products.byteblower.run.utils.LocalLatencyResultData;
import com.excentis.products.byteblower.run.utils.LocalOutOfSequenceResultData;
import com.excentis.products.byteblower.run.utils.LocalTriggerResultData;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.map.MultiValueMap;

public class FbFlowHandle
extends BaseHandle
implements CreateFlow.Listener,
CreateFlows.Listener,
ConfigureFlow.Listener,
ConfigureFlows.Listener,
ImproveFilters.Listener,
RunScenario.Listener,
ConfigureFlowTrafficFb.Listener,
CreateFrame.Listener {
    private static final String IPV6_LATENCY_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/118";
    private static final String IPV4_LATENCY_ARTICLE = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/117";
    private static final String ARTICLE_COLLIDING_FRAMES = "https://support.excentis.com/index.php?/Knowledgebase/Article/View/148";
    private static final Logger LOGGER = Logger.getGlobal();
    private final EventManager eventManager;
    private final Ipv4AddressManager ipv4AddressManager;
    private final Ipv6AddressManager ipv6AddressManager;
    private final PortManager portManager;
    private final FlowInstanceManager flowInstanceManager;
    private final FbFlowInstanceManager fbFlowInstanceManager;
    private final BaseEntityManager<FbSource> fbSourceManager;
    private final BaseEntityManager<FbDestinationConfig> fbDestinationConfigManager;
    private final BaseEntityManager<FbDestination> fbDestinationManager;
    private final MulticastConfigurationManager multicastConfigurationManager;
    private final BaseEntityManager<MulticastMember> multicastMemberManager;
    private final MulticastSourceGroupManager multicastSourceGroupManager;
    private final BaseEntityManager<MulticastSource> multicastSourceManager;
    private final BaseEntityManager<FbTrigger> fbTriggerManager;
    private final BaseEntityManager<FbTriggerSnapshot> fbTriggerSnapshotManager;
    private final BaseEntityManager<FbOutOfSequence> fbOutOfSequenceManager;
    private final BaseEntityManager<FbLatency> fbLatencyManager;
    private final Set<RuntimeFbFlow> flowTxErrorMap = new HashSet<RuntimeFbFlow>();
    private final Set<RuntimeFbFlow> flowTxOutOfResourcesMap = new HashSet<RuntimeFbFlow>();
    private final Map<RuntimeFlow, FbFlowInstance> fbFlowInstanceCache = new HashMap<RuntimeFlow, FbFlowInstance>();
    private final TestDataPersistenceController pc;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$model$MldVersion = FbFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$model$MldVersion();
        $SWITCH_TABLE$com$excentis$products$byteblower$model$MulticastFilterType = FbFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$model$MulticastFilterType();
        $SWITCH_TABLE$com$excentis$products$byteblower$model$IgmpVersion = FbFlowHandle.$SWITCH_TABLE$com$excentis$products$byteblower$model$IgmpVersion();
    }

    public FbFlowHandle(TestDataPersistenceController pc) {
        super(pc);
        this.pc = pc;
        this.eventManager = new EventManager(pc);
        this.ipv4AddressManager = new Ipv4AddressManager(pc);
        this.ipv6AddressManager = new Ipv6AddressManager(pc);
        this.portManager = new PortManager(pc);
        this.flowInstanceManager = new FlowInstanceManager(pc);
        this.fbFlowInstanceManager = new FbFlowInstanceManager(pc);
        this.fbSourceManager = new BaseEntityManager(FbSource.class, pc);
        this.fbDestinationConfigManager = new BaseEntityManager(FbDestinationConfig.class, pc);
        this.fbDestinationManager = new BaseEntityManager(FbDestination.class, pc);
        this.multicastConfigurationManager = new MulticastConfigurationManager(pc);
        this.multicastMemberManager = new BaseEntityManager(MulticastMember.class, pc);
        this.multicastSourceGroupManager = new MulticastSourceGroupManager(pc);
        this.multicastSourceManager = new BaseEntityManager(MulticastSource.class, pc);
        this.fbTriggerManager = new BaseEntityManager(FbTrigger.class, pc);
        this.fbTriggerSnapshotManager = new BaseEntityManager(FbTriggerSnapshot.class, pc);
        this.fbOutOfSequenceManager = new BaseEntityManager(FbOutOfSequence.class, pc);
        this.fbLatencyManager = new BaseEntityManager(FbLatency.class, pc);
    }

    @Override
    public void register(Context context) {
        context.listen(CreateFlow.Listener.class, (Object)this);
        context.listen(CreateFlows.Listener.class, (Object)this);
        context.listen(ConfigureFlow.Listener.class, (Object)this);
        context.listen(ConfigureFlows.Listener.class, (Object)this);
        context.listen(ImproveFilters.Listener.class, (Object)this);
        context.listen(RunScenario.Listener.class, (Object)this);
        context.listen(ConfigureFlowTrafficFb.Listener.class, (Object)this);
        context.listen(CreateFrame.Listener.class, (Object)this);
    }

    public void onFlowCreated(RuntimeFlow runtimeFlow) {
        if (!RuntimeFlow.Type.FB.equals((Object)runtimeFlow.getType())) {
            return;
        }
        if (!(runtimeFlow instanceof RuntimeFbFlow) && !(runtimeFlow instanceof RuntimeGroupFbFlow)) {
            return;
        }
        FlowMeasurementReader reader = runtimeFlow.getModelFlowInstanceReader();
        FrameBlastingUtils utils = new FrameBlastingUtils(this.pc);
        FbFlowInstance fbFlowInstance = utils.persistFbFlowInstance(reader);
        this.fbFlowInstanceCache.put(runtimeFlow, fbFlowInstance);
    }

    public void onFlowCreationFailed(FlowMeasurement flowMeasurement, String errorMessage) {
        if (!(flowMeasurement.getFlow().getFlowTemplate() instanceof FrameBlastingFlow)) {
            return;
        }
        String flowName = flowMeasurement.getFlow().getName();
        FlowMeasurementReader reader = ReaderFactory.create((FlowMeasurement)flowMeasurement);
        FrameBlastingUtils utils = new FrameBlastingUtils(this.pc);
        FbFlowInstance fbFlowInstance = utils.persistFbFlowInstance(reader);
        fbFlowInstance.setStatus(FlowInstanceStatus.CONFIGURATION_ERROR);
        this.fbFlowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        String message = "Failed to create flow instance '" + flowName + "' due to following error:\n" + errorMessage;
        this.logFlowEvent(fbFlowInstance, message, EventSeverity.TEST_ERROR);
    }

    public void onFlowsCreated(RuntimeScenario rtScenario) {
    }

    public void onFlowConfigured(RuntimeFlow runtimeFlow) {
        if (!(runtimeFlow instanceof RuntimeFbFlow) && !(runtimeFlow instanceof RuntimeGroupFbFlow)) {
            return;
        }
        if (runtimeFlow instanceof RuntimeGroupFbFlow) {
            RuntimeGroupFbFlow group = (RuntimeGroupFbFlow)runtimeFlow;
            FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)group);
            for (RuntimeFbFlow child : group.getChilderen()) {
                FbFlowInstance childInstance = this.getCachedFbFlowInstance((RuntimeFlow)child);
                childInstance.setParent((FlowInstance)fbFlowInstance);
                this.flowInstanceManager.persistIdEntity((BaseEntity)childInstance);
            }
        }
        FbFlowInstance fbFlowInstance = this.persistEndpoints(runtimeFlow);
        this.createResultContainers(runtimeFlow, fbFlowInstance);
        fbFlowInstance.setStatus(FlowInstanceStatus.CONFIGURED);
        this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        String message = "Frame blasting flow '" + runtimeFlow.name() + "' configured";
        this.logFlowEvent(fbFlowInstance, message, EventSeverity.TEST_LOG);
    }

    public void onFlowConfigurationFailed(RuntimeFlow runtimeFlow, String errorMessage) {
        if (!(runtimeFlow instanceof RuntimeFbFlow)) {
            return;
        }
        RuntimeFbFlow rtFbFlow = (RuntimeFbFlow)runtimeFlow;
        FbFlowInstance fbFlowInstance = this.persistEndpoints((RuntimeFlow)rtFbFlow);
        fbFlowInstance.setStatus(FlowInstanceStatus.CONFIGURATION_ERROR);
        this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        String message = "Failed to configure frame blasting flow '" + rtFbFlow.name() + "' due to following error:\n" + errorMessage;
        this.logFlowEvent(fbFlowInstance, message, EventSeverity.TEST_ERROR);
    }

    private FbFlowInstance persistEndpoints(RuntimeFlow rtFbFlow) {
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance(rtFbFlow);
        this.persistSource(fbFlowInstance, rtFbFlow.getRuntimeFlowSource());
        this.persistDestinationConfig(fbFlowInstance, rtFbFlow.getRuntimeFlowDestination());
        return fbFlowInstance;
    }

    private FbSource persistSource(FbFlowInstance fbFlowInstance, RuntimeFlowSource runtimeFlowSource) {
        String sourcePortName = runtimeFlowSource.getRuntimePort().getName();
        Port sourcePort = this.portManager.find(sourcePortName);
        FbSource fbSource = new FbSource(fbFlowInstance, sourcePort);
        this.fbSourceManager.persistIdEntity((BaseEntity)fbSource);
        return fbSource;
    }

    private FbDestinationConfig persistDestinationConfig(FbFlowInstance fbFlowInstance, RuntimeFlowDestination rtFlowDestination) {
        FbDestinationConfigUnicast fbDestinationConfig;
        if (rtFlowDestination instanceof RuntimePortDestination) {
            RuntimePortDestination rtPortFlowDestination = (RuntimePortDestination)rtFlowDestination;
            RuntimePort rtDestinationPort = rtPortFlowDestination.getRuntimePort();
            FbDestination destination = this.persistFbDestination(rtDestinationPort);
            fbDestinationConfig = new FbDestinationConfigUnicast(fbFlowInstance, destination);
            this.fbDestinationConfigManager.persistIdEntity((BaseEntity)fbDestinationConfig);
        } else if (rtFlowDestination instanceof RuntimeMulticastDestination) {
            RuntimeMulticastDestination rtMulticastFlowDestination = (RuntimeMulticastDestination)rtFlowDestination;
            MulticastGroup mMulticastGroup = rtMulticastFlowDestination.getModelMulticastGroup();
            MulticastConfiguration multicastConfiguration = this.multicastConfigurationManager.find(mMulticastGroup.getName());
            if (multicastConfiguration == null) {
                multicastConfiguration = this.persistMulticastConfiguration(mMulticastGroup);
            }
            fbDestinationConfig = new FbDestinationConfigMulticast(fbFlowInstance, multicastConfiguration);
            this.fbDestinationConfigManager.persistIdEntity((BaseEntity)fbDestinationConfig);
            for (RuntimePort rtDestinationPort : rtMulticastFlowDestination.getRuntimePorts()) {
                FbDestination fbDestination = this.persistFbDestination(rtDestinationPort);
                ((FbDestinationConfigMulticast)fbDestinationConfig).addDestination(fbDestination);
            }
        } else if (rtFlowDestination instanceof RuntimeFixedDestination) {
            RuntimeFixedDestination rtFixedFlowDestination = (RuntimeFixedDestination)rtFlowDestination;
            String ipAddressString = rtFixedFlowDestination.getIPAddress();
            fbDestinationConfig = this.createFixedDestConfigForIpAddressString(fbFlowInstance, (RuntimeFlowDestination)rtFixedFlowDestination, ipAddressString);
            this.fbDestinationConfigManager.persistIdEntity((BaseEntity)fbDestinationConfig);
        } else {
            List ports = rtFlowDestination.getRuntimePorts();
            if (ports.size() == 0) {
                throw new UnsupportedOperationException("Runtime flow destination type " + rtFlowDestination.getClass().getSimpleName() + " not supported by datagathering");
            }
            FbDestination destination = this.persistFbDestination(rtFlowDestination.toString());
            fbDestinationConfig = new FbDestinationConfigUnicast(fbFlowInstance, destination);
            this.fbDestinationConfigManager.persistIdEntity((BaseEntity)fbDestinationConfig);
        }
        for (RuntimePortDestination rtEavesdropper : rtFlowDestination.getRuntimeFlow().getRuntimeEavesdroppers()) {
            RuntimePort rtEavesdropperPort = rtEavesdropper.getRuntimePort();
            FbDestination fbEavesdropperDestination = this.persistFbDestination(rtEavesdropperPort);
            fbDestinationConfig.addEavesdropper(fbEavesdropperDestination);
        }
        return fbDestinationConfig;
    }

    private FbDestination persistFbDestination(RuntimePort rtPort) {
        String portName = rtPort.getName();
        return this.persistFbDestination(portName);
    }

    private FbDestination persistFbDestination(String portName) {
        Port port = this.portManager.find(portName);
        FbDestination fbDestination = new FbDestination(port);
        this.fbDestinationManager.persistIdEntity((BaseEntity)fbDestination);
        return fbDestination;
    }

    private MulticastConfiguration persistMulticastConfiguration(MulticastGroup multicastGroup) {
        MulticastConfigurationIpv4 multicastConfiguration;
        MulticastGroupReader reader = ReaderFactory.create((MulticastGroup)multicastGroup);
        String name = multicastGroup.getName();
        String multicastIpAddressString = reader.getMulticastIpAddressString();
        if (reader.isIpv4()) {
            com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address multicastIpv4Address = this.ipv4AddressManager.findOrCreate(multicastIpAddressString);
            multicastConfiguration = new MulticastConfigurationIpv4(name, multicastIpv4Address);
        } else if (reader.isIpv6()) {
            Ipv6Address multicastIpv6Address = this.ipv6AddressManager.findOrCreate(multicastIpAddressString);
            multicastConfiguration = new MulticastConfigurationIpv6(name, multicastIpv6Address);
        } else {
            throw new UnsupportedOperationException("Runtime multicast type not supported by datagathering");
        }
        this.multicastConfigurationManager.persistIdEntity((BaseEntity)multicastConfiguration);
        for (MulticastMemberPort mMulticastMemberPort : multicastGroup.getMulticastMemberPort()) {
            this.persistMulticastMember((MulticastConfiguration)multicastConfiguration, mMulticastMemberPort);
        }
        return multicastConfiguration;
    }

    private MulticastMember persistMulticastMember(MulticastConfiguration multicastConfiguration, MulticastMemberPort multicastMemberPort) {
        MulticastMember multicastMember = null;
        String memberPortName = multicastMemberPort.getByteBlowerGuiPort().getName();
        Port memberPort = this.portManager.find(memberPortName);
        MulticastProtocol protocol = this.getMulticastProtocol(multicastMemberPort);
        if (MulticastProtocol.isSsm((MulticastProtocol)protocol)) {
            com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceGroup sourceGroup;
            MulticastSourceGroup mMcSourceGroup = multicastMemberPort.getMulticastSourceGroup();
            if (mMcSourceGroup != null) {
                sourceGroup = this.multicastSourceGroupManager.find(mMcSourceGroup.getName());
                if (sourceGroup == null) {
                    sourceGroup = this.persistMulticastSourceGroup(mMcSourceGroup);
                }
            } else {
                sourceGroup = null;
            }
            MulticastFilterType filterType = multicastMemberPort.getMulticastSourceFilter();
            MulticastSourceFilterType sourceFilterType = this.convertMulticastSourceFilterType(filterType);
            multicastMember = new MulticastMemberSsm(multicastConfiguration, memberPort, protocol, sourceFilterType, sourceGroup);
        } else {
            multicastMember = new MulticastMember(multicastConfiguration, memberPort, protocol);
        }
        this.multicastMemberManager.persistIdEntity((BaseEntity)multicastMember);
        return multicastMember;
    }

    private com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceGroup persistMulticastSourceGroup(MulticastSourceGroup sourceGroup) {
        String sourceGroupName = sourceGroup.getName();
        com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceGroup multicastSourceGroup = new com.excentis.products.byteblower.results.testdata.data.entities.MulticastSourceGroup(sourceGroupName);
        this.multicastSourceGroupManager.persistIdEntity((BaseEntity)multicastSourceGroup);
        for (MulticastSourceByteBlowerGuiPort mMcSourcePort : sourceGroup.getMulticastSourceByteBlowerGuiPort()) {
            Port sourcePort = this.portManager.find(mMcSourcePort.getByteBlowerGuiPort().getName());
            MulticastSourcePort multicastSource = new MulticastSourcePort(multicastSourceGroup, sourcePort);
            this.multicastSourceManager.persistIdEntity((BaseEntity)multicastSource);
        }
        for (IpAddress mIpAddress : sourceGroup.getIpAddresses()) {
            MulticastSourceIpv4 multicastSource;
            String ipAddressString = IpAddressReaderImpl.getAddress((IpAddress)mIpAddress);
            if (mIpAddress instanceof Ipv4Address) {
                com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address ipv4Address = this.ipv4AddressManager.findOrCreate(ipAddressString);
                multicastSource = new MulticastSourceIpv4(multicastSourceGroup, ipv4Address);
                this.multicastSourceManager.persistIdEntity((BaseEntity)multicastSource);
                continue;
            }
            if (mIpAddress instanceof com.excentis.products.byteblower.model.Ipv6Address) {
                Ipv6Address ipv6Address = this.ipv6AddressManager.findOrCreate(ipAddressString);
                multicastSource = new MulticastSourceIpv6(multicastSourceGroup, ipv6Address);
                this.multicastSourceManager.persistIdEntity((BaseEntity)multicastSource);
                continue;
            }
            throw new UnsupportedOperationException("Runtime multicast member type not supported by datagathering");
        }
        return multicastSourceGroup;
    }

    private MulticastProtocol getMulticastProtocol(MulticastMemberPort mMulticastMemberPort) {
        if (mMulticastMemberPort instanceof Ipv4MulticastMemberPort) {
            switch (((Ipv4MulticastMemberPort)mMulticastMemberPort).getIgmpVersion()) {
                case IGM_PV1_LITERAL: {
                    return MulticastProtocol.IGMPV1;
                }
                case IGM_PV2_LITERAL: {
                    return MulticastProtocol.IGMPV2;
                }
                case IGM_PV3_LITERAL: {
                    return MulticastProtocol.IGMPV3;
                }
            }
            return null;
        }
        if (mMulticastMemberPort instanceof Ipv6MulticastMemberPort) {
            switch (((Ipv6MulticastMemberPort)mMulticastMemberPort).getMldVersion()) {
                case ML_DV1_LITERAL: {
                    return MulticastProtocol.MLDV1;
                }
                case ML_DV2_LITERAL: {
                    return MulticastProtocol.MLDV2;
                }
            }
            return null;
        }
        return null;
    }

    private MulticastSourceFilterType convertMulticastSourceFilterType(MulticastFilterType filtertype) {
        switch (filtertype) {
            case EXCLUDE: {
                return MulticastSourceFilterType.EXCLUDE;
            }
            case INCLUDE: {
                return MulticastSourceFilterType.INCLUDE;
            }
        }
        return null;
    }

    private FbDestinationConfig createFixedDestConfigForIpAddressString(FbFlowInstance flowInstance, RuntimeFlowDestination rtFlowDestination, String ipAddressString) {
        RuntimePort sourcePort = rtFlowDestination.getRuntimeFlow().getRuntimeFlowSource().getRuntimePort();
        if (sourcePort.isRuntimeLayer3Ipv4()) {
            com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address ipv4Address = this.ipv4AddressManager.findOrCreate(ipAddressString);
            return new FbDestinationConfigFixedIpv4(flowInstance, ipv4Address);
        }
        if (sourcePort.isRuntimeLayer3Ipv6()) {
            Ipv6Address ipv6Address = this.ipv6AddressManager.findOrCreate(ipAddressString);
            return new FbDestinationConfigFixedIpv6(flowInstance, ipv6Address);
        }
        throw new UnsupportedOperationException("Fixed destination layer 3 type not supported by datagathering");
    }

    private void createResultContainers(RuntimeFlow rtFbFlow, FbFlowInstance fbFlowInstance) {
        FbSource source = fbFlowInstance.getSource();
        FbTrigger fbTxTrigger = new FbTrigger();
        this.fbTriggerManager.persistIdEntity((BaseEntity)fbTxTrigger);
        source.setTrigger(fbTxTrigger);
        this.fbSourceManager.persistIdEntity((BaseEntity)source);
        for (FbDestination fbDestination : this.fbFlowInstanceManager.getFbDestinationsAndEavesdroppers(fbFlowInstance)) {
            FbTrigger fbRxTrigger = new FbTrigger();
            this.fbTriggerManager.persistIdEntity((BaseEntity)fbRxTrigger);
            fbDestination.setTrigger(fbRxTrigger);
            if (rtFbFlow.hasOutOfSequenceDetection()) {
                FbOutOfSequence fbOutOfSequence = new FbOutOfSequence();
                this.fbOutOfSequenceManager.persistIdEntity((BaseEntity)fbOutOfSequence);
                fbDestination.setOutOfSequence(fbOutOfSequence);
            }
            if (rtFbFlow.hasLatencyMeasurement()) {
                FbLatency fbLatency = new FbLatency();
                this.fbLatencyManager.persistIdEntity((BaseEntity)fbLatency);
                fbDestination.setLatency(fbLatency);
            }
            this.fbDestinationManager.persistIdEntity((BaseEntity)fbDestination);
        }
    }

    public void onFlowsConfigured(RuntimeScenario rtScenario) {
    }

    public void onFiltersImproved(RuntimeScenario rtScenario, MultiValueMap rtFbFramesIdentical, MultiValueMap rtFbFramesIndistinguishable) {
        Date time = new Date();
        for (ImproveFilters.InterfaceFrame key : rtFbFramesIdentical.keySet()) {
            this.handleCollidingFrame((RuntimeFrame)key.getFrame(), key.getBbInterface(), rtFbFramesIdentical.getCollection((Object)key), "identical to", time);
        }
        for (ImproveFilters.InterfaceFrame key : rtFbFramesIndistinguishable.keySet()) {
            this.handleCollidingFrame((RuntimeFrame)key.getFrame(), key.getBbInterface(), rtFbFramesIndistinguishable.getCollection((Object)key), "indistinguishable from", time);
        }
    }

    private void handleCollidingFrame(RuntimeFrame rtFrame, RuntimeInterface rtInterface, Collection<RuntimeFrame> collidingFrames, String characteristic, Date time) {
        String conflictingFramesString = this.prettyPrintConflictingFrames(collidingFrames);
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance(rtFrame.getRuntimeFlow());
        if (fbFlowInstance.getStatus() == FlowInstanceStatus.CONFIGURED) {
            fbFlowInstance.setStatus(FlowInstanceStatus.CONFIGURED_WARNING);
            this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        }
        String frameName = rtFrame.getName();
        String flowName = rtFrame.getRuntimeFlow().name();
        String pluralFrameDescription = collidingFrames.size() == 1 ? "a frame" : String.valueOf(collidingFrames.size()) + " frames";
        String pluralFlowDescription = collidingFrames.size() == 1 ? "another flow" : "other flows";
        String serverLocation = rtInterface.getRuntimeServer().getIPAddress();
        String messageFmt = "Frame '%s' of flow '%s' is %s %s of %s when arriving at %s on server %s. Unexpected packets may match this flow's filter and influence RX results.\n(problematic frames: %s)";
        String filledMessage = String.format("Frame '%s' of flow '%s' is %s %s of %s when arriving at %s on server %s. Unexpected packets may match this flow's filter and influence RX results.\n(problematic frames: %s)", frameName, flowName, characteristic, pluralFrameDescription, pluralFlowDescription, rtInterface.getCode(), serverLocation, conflictingFramesString);
        EventSeverity severity = EventSeverity.TEST_WARNING;
        FlowInstanceEvent event = new FlowInstanceEvent(time, filledMessage, severity, (FlowInstance)fbFlowInstance);
        event.setKnowledgebaseLink(ARTICLE_COLLIDING_FRAMES);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private String prettyPrintConflictingFrames(Collection<RuntimeFrame> rtFramesConflicting) {
        String[] parts = new String[rtFramesConflicting.size()];
        int i = 0;
        for (RuntimeFrame rtFrame : rtFramesConflicting) {
            String errorFormat = "'%s' of '%s'";
            parts[i] = String.format("'%s' of '%s'", rtFrame.getName(), rtFrame.getRuntimeFlow().name());
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parts[0]);
        if (parts.length > 1) {
            i = 1;
            while (i < parts.length - 1) {
                sb.append(", " + parts[i]);
                ++i;
            }
            sb.append(" and " + parts[parts.length - 1]);
        }
        return sb.toString();
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
        FbFlowInstance fbFlowInstance;
        for (RuntimeFlow rtFbFlow : rtScenario.getRuntimeFlows()) {
            String msg;
            String msgFormat;
            if (!(rtFbFlow instanceof RuntimeGroupFbFlow)) continue;
            fbFlowInstance = this.getCachedFbFlowInstance(rtFbFlow);
            FlowInstanceStatus status = FlowInstanceStatus.ACTIVE;
            int badCount = 0;
            int goodCount = 0;
            RuntimeGroupFbFlow group = (RuntimeGroupFbFlow)rtFbFlow;
            for (RuntimeFbFlow child : group.getChilderen()) {
                FbFlowInstance childInstance = this.getCachedFbFlowInstance((RuntimeFlow)child);
                FlowInstanceStatus childStatus = childInstance.getStatus();
                if (childStatus == FlowInstanceStatus.STOPPED_ERROR || childStatus == FlowInstanceStatus.CONFIGURATION_ERROR) {
                    ++badCount;
                    continue;
                }
                ++goodCount;
            }
            if (badCount > 0 && goodCount > 0) {
                status = FlowInstanceStatus.ACTIVE_WARNING;
                msgFormat = "Not all subflows were properly intialized (%d out of %d).\n Only partial results are available.";
                msg = String.format(msgFormat, badCount, badCount + goodCount);
                this.logFlowEvent(fbFlowInstance, msg, EventSeverity.TEST_WARNING);
            } else if (goodCount == 0) {
                status = FlowInstanceStatus.STOPPED_ERROR;
                msgFormat = "No flow was initialized. No results are available on this flow.";
                msg = String.format(msgFormat, badCount, badCount + goodCount);
                this.logFlowEvent(fbFlowInstance, msg, EventSeverity.TEST_ERROR);
            }
            fbFlowInstance.setStatus(status);
            this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        }
        for (RuntimeFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            fbFlowInstance = this.getCachedFbFlowInstance(rtFbFlow);
            if (fbFlowInstance.getStatus() == FlowInstanceStatus.CONFIGURED) {
                fbFlowInstance.setStatus(FlowInstanceStatus.ACTIVE);
            } else if (fbFlowInstance.getStatus() == FlowInstanceStatus.CONFIGURED_WARNING) {
                fbFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
            } else {
                throw new IllegalStateException("Unexpected flow status: " + fbFlowInstance.getStatus() + " in " + rtFbFlow);
            }
            this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        }
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        this.handleResultsOverTime(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        boolean isScenarioFinished = true;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
        for (RuntimeFbFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtFbFlow);
            if (fbFlowInstance.getStatus() == FlowInstanceStatus.ACTIVE) {
                fbFlowInstance.setStatus(FlowInstanceStatus.STOPPED);
            } else if (fbFlowInstance.getStatus() == FlowInstanceStatus.ACTIVE_WARNING) {
                fbFlowInstance.setStatus(FlowInstanceStatus.STOPPED_WARNING);
            } else {
                throw new IllegalStateException("Unexpected flow status");
            }
            this.flowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
        }
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        boolean isScenarioFinished = false;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        boolean isScenarioFinished = false;
        this.handleResultsOverTime(rtScenario);
        this.handleGlobalResults(rtScenario, isScenarioFinished);
    }

    static FbDestination getDestination(String portName, FbFlowInstanceReader fbFlowInstanceReader) {
        for (FbDestination fbDestination : fbFlowInstanceReader.getDestinationsAndEavesdroppers()) {
            if (!portName.equals(fbDestination.getPort().getName())) continue;
            return fbDestination;
        }
        return null;
    }

    static FbDestination getDestination(RuntimePort port, FbFlowInstanceReader fbFlowInstanceReader) {
        for (FbDestination fbDestination : fbFlowInstanceReader.getDestinationsAndEavesdroppers()) {
            if (!port.getName().equals(fbDestination.getPort().getName())) continue;
            return fbDestination;
        }
        return null;
    }

    private void handleResultsOverTime(RuntimeScenario rtScenario) {
        boolean shouldSaveInterval = rtScenario.allowResultsOverTime();
        for (RuntimeFlow rtFlow : rtScenario.getRuntimeFlowsConfigured()) {
            if (!(rtFlow instanceof RuntimeGroupFbFlow)) continue;
            this.handleResultsOvertime((RuntimeGroupFbFlow)rtFlow, shouldSaveInterval);
        }
        for (RuntimeFbFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            this.handleResultsOvertime(rtFbFlow, shouldSaveInterval);
        }
    }

    private void handleResultsOvertime(final RuntimeGroupFbFlow rtGroupFbFlow, boolean shouldSaveInterval) {
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtGroupFbFlow);
        FbSource fbSource = fbFlowInstance.getSource();
        this.updateResultsOverTime(fbSource.getTrigger(), rtGroupFbFlow.txIntervalSnapshots(), 1000000000L, shouldSaveInterval);
        final FbFlowInstanceReader fbFlowInstanceReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
        StoreIntervalSnapshots updateResultsSnapshot = new StoreIntervalSnapshots(this.pc, rtGroupFbFlow.getRuntimeFlowDestination().toString(), fbFlowInstanceReader, shouldSaveInterval);
        rtGroupFbFlow.visitSnapshots((RuntimeRx.SnapshotVisitor)updateResultsSnapshot);
        this.updateOverallResults(fbSource.getTrigger(), rtGroupFbFlow.txCumulativeSnapshot());
        rtGroupFbFlow.visitCumulativeSnapshots(new RuntimeRx.SnapshotVisitor(){

            public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
                if (trigger.length == 0) {
                    return;
                }
                FbDestination destination = FbFlowHandle.getDestination(rtGroupFbFlow.getRuntimeFlowDestination().toString(), fbFlowInstanceReader);
                FbOutOfSequence fbOutOfSequence = destination.getOutOfSequence();
                LocalOutOfSequenceResultData last = trigger[trigger.length - 1];
                Long intervalDuration = last.IntervalDurationGet();
                if (fbOutOfSequence.getSnapshotResolution() == null) {
                    fbOutOfSequence.setSnapshotResolution(intervalDuration);
                }
                fbOutOfSequence.setPacketCountValid(Long.valueOf(last.PacketCountValidGet()));
                fbOutOfSequence.setPacketCountInvalid(Long.valueOf(last.PacketCountInvalidGet()));
                fbOutOfSequence.setPacketCountOutOfSequence(Long.valueOf(last.PacketCountOutOfSequenceGet()));
                FbFlowHandle.this.fbOutOfSequenceManager.persistIdEntity((BaseEntity)fbOutOfSequence);
            }

            public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
            }

            public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
                FbDestination destination = FbFlowHandle.getDestination(rtGroupFbFlow.getRuntimeFlowDestination().toString(), fbFlowInstanceReader);
                if (destination == null) {
                    return;
                }
                if (trigger.length == 0) {
                    return;
                }
                FbTrigger fbTrigger = destination.getTrigger();
                LocalTriggerResultData last = trigger[trigger.length - 1];
                long intervalDuration = last.IntervalDurationGet();
                if (fbTrigger.getSnapshotResolution() == null) {
                    fbTrigger.setSnapshotResolution(intervalDuration);
                }
                FbFlowHandle.this.updateOverallResults(destination.getTrigger(), last);
            }

            public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
                long latestPacketCount;
                FbDestination destination = FbFlowHandle.getDestination(rtGroupFbFlow.getRuntimeFlowDestination().toString(), fbFlowInstanceReader);
                if (destination == null) {
                    return;
                }
                if (trigger.length == 0) {
                    return;
                }
                FbLatency fbLatency = destination.getLatency();
                LocalLatencyResultData last = trigger[trigger.length - 1];
                long intervalDuration = last.IntervalDurationGet();
                if (fbLatency.getSnapshotResolution() == null) {
                    fbLatency.setSnapshotResolution(Long.valueOf(intervalDuration));
                }
                if ((latestPacketCount = last.PacketCountGet()) > 0L) {
                    fbLatency.setPacketCountValid(Long.valueOf(last.PacketCountValidGet()));
                    fbLatency.setPacketCountInvalid(Long.valueOf(last.PacketCountInvalidGet()));
                    fbLatency.setLatencyMinimum(Long.valueOf(last.LatencyMinimumGet()));
                    fbLatency.setLatencyAverage(Long.valueOf(last.LatencyAverageGet()));
                    fbLatency.setLatencyMaximum(Long.valueOf(last.LatencyMaximumGet()));
                    fbLatency.setJitter(Long.valueOf(last.JitterGet()));
                }
                FbFlowHandle.this.fbLatencyManager.persistIdEntity((BaseEntity)fbLatency);
            }
        });
    }

    private void handleResultsOvertime(RuntimeFbFlow rtFbFlow, boolean shouldSaveInterval) {
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtFbFlow);
        final FbFlowInstanceReader fbFlowInstanceReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
        FbSource fbSource = fbFlowInstance.getSource();
        if (!this.flowHasTxOutOfResourcesEvent(rtFbFlow) && rtFbFlow.hasTxOutOfResourcesErrorCode()) {
            this.flowSetTxOutOfResourcesEvent(rtFbFlow);
            fbFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
            String ifName = rtFbFlow.getSourceRuntimePort().getInterfaceName();
            String message = "Frame blasting flow '" + rtFbFlow.name() + "' on '" + ifName + "' was out of resources while trying to transmit it's intended traffic load.";
            StreamRuntimeStatus.transmit_error_source errorSource = rtFbFlow.getErrorSource();
            String cause = this.humanErrorMessage(errorSource);
            if (!cause.isEmpty()) {
                message = String.valueOf(message) + " Cause : " + cause;
            }
            this.logFlowEvent(fbFlowInstance, message, EventSeverity.TEST_WARNING);
        }
        if (!this.flowHasTxErrorEvent(rtFbFlow) && rtFbFlow.hasTxOtherErrorCode()) {
            this.flowSetTxErrorEvent(rtFbFlow);
            fbFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
            String message = "Frame blasting flow '" + rtFbFlow.name() + "' encountered unknown error while transmitting it's intended traffic load.";
            EventSeverity severity = EventSeverity.TEST_WARNING;
            this.logFlowEvent(fbFlowInstance, message, severity);
        }
        this.updateTxTriggerResult(fbSource.getTrigger(), rtFbFlow, shouldSaveInterval);
        StoreIntervalSnapshots updateResultsSnapshot = new StoreIntervalSnapshots(this.pc, fbFlowInstanceReader, shouldSaveInterval);
        rtFbFlow.visitSnapshots((RuntimeRx.SnapshotVisitor)updateResultsSnapshot);
        rtFbFlow.visitCumulativeSnapshots(new RuntimeRx.SnapshotVisitor(){

            public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
                if (trigger.length == 0) {
                    return;
                }
                FbDestination destination = FbFlowHandle.getDestination(port, fbFlowInstanceReader);
                FbOutOfSequence fbOutOfSequence = destination.getOutOfSequence();
                LocalOutOfSequenceResultData last = trigger[trigger.length - 1];
                Long intervalDuration = last.IntervalDurationGet();
                if (fbOutOfSequence.getSnapshotResolution() == null) {
                    fbOutOfSequence.setSnapshotResolution(intervalDuration);
                }
                fbOutOfSequence.setPacketCountValid(Long.valueOf(last.PacketCountValidGet()));
                fbOutOfSequence.setPacketCountInvalid(Long.valueOf(last.PacketCountInvalidGet()));
                fbOutOfSequence.setPacketCountOutOfSequence(Long.valueOf(last.PacketCountOutOfSequenceGet()));
                FbFlowHandle.this.fbOutOfSequenceManager.persistIdEntity((BaseEntity)fbOutOfSequence);
            }

            public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
            }

            public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
                FbDestination destination = FbFlowHandle.getDestination(port, fbFlowInstanceReader);
                if (destination == null) {
                    return;
                }
                if (trigger.length == 0) {
                    return;
                }
                FbTrigger fbTrigger = destination.getTrigger();
                LocalTriggerResultData last = trigger[trigger.length - 1];
                long intervalDuration = last.IntervalDurationGet();
                if (fbTrigger.getSnapshotResolution() == null) {
                    fbTrigger.setSnapshotResolution(intervalDuration);
                }
                fbTrigger.setByteCount(last.ByteCountGet());
                long packetCount = last.PacketCountGet();
                fbTrigger.setPacketCount(packetCount);
                Long firstTimestamp = null;
                Long lastTimestamp = null;
                if (packetCount > 0L) {
                    firstTimestamp = last.TimestampFirstGet();
                    lastTimestamp = last.TimestampLastGet();
                }
                fbTrigger.setFirstPacketTime(firstTimestamp);
                fbTrigger.setLastPacketTime(lastTimestamp);
                FbFlowHandle.this.fbTriggerManager.lightUpdate((BaseEntity)fbTrigger);
            }

            public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
                long latestPacketCount;
                FbDestination destination = FbFlowHandle.getDestination(port, fbFlowInstanceReader);
                if (destination == null) {
                    return;
                }
                if (trigger.length == 0) {
                    return;
                }
                FbLatency fbLatency = destination.getLatency();
                LocalLatencyResultData last = trigger[trigger.length - 1];
                long intervalDuration = last.IntervalDurationGet();
                if (fbLatency.getSnapshotResolution() == null) {
                    fbLatency.setSnapshotResolution(Long.valueOf(intervalDuration));
                }
                if ((latestPacketCount = last.PacketCountGet()) > 0L) {
                    fbLatency.setPacketCountValid(Long.valueOf(last.PacketCountValidGet()));
                    fbLatency.setPacketCountInvalid(Long.valueOf(last.PacketCountInvalidGet()));
                    fbLatency.setLatencyMinimum(Long.valueOf(last.LatencyMinimumGet()));
                    fbLatency.setLatencyAverage(Long.valueOf(last.LatencyAverageGet()));
                    fbLatency.setLatencyMaximum(Long.valueOf(last.LatencyMaximumGet()));
                    fbLatency.setJitter(Long.valueOf(last.JitterGet()));
                }
                FbFlowHandle.this.fbLatencyManager.persistIdEntity((BaseEntity)fbLatency);
            }
        });
    }

    private String humanErrorMessage(StreamRuntimeStatus.transmit_error_source errorSource) {
        String cause = errorSource == StreamRuntimeStatus.transmit_error_source.INTERFACE_HARDWARE ? "Interface hardware limit exceeded." : (errorSource == StreamRuntimeStatus.transmit_error_source.SCHEDULING_CONFLICT ? "Transmission scheduling conflict." : (errorSource == StreamRuntimeStatus.transmit_error_source.TXUSER ? "Application transmission resource limit exceeded." : "Unknown."));
        return cause;
    }

    private void logFlowEvent(FbFlowInstance fbFlowInstance, String message, EventSeverity severity) {
        Date time = new Date();
        FlowInstanceEvent event = new FlowInstanceEvent(time, message, severity, (FlowInstance)fbFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private void flowSetTxErrorEvent(RuntimeFbFlow rtFbFlow) {
        this.flowTxErrorMap.add(rtFbFlow);
    }

    private boolean flowHasTxErrorEvent(RuntimeFbFlow rtFbFlow) {
        return this.flowTxErrorMap.contains(rtFbFlow);
    }

    private void flowSetTxOutOfResourcesEvent(RuntimeFbFlow rtFbFlow) {
        this.flowTxOutOfResourcesMap.add(rtFbFlow);
    }

    private boolean flowHasTxOutOfResourcesEvent(RuntimeFbFlow rtFbFlow) {
        return this.flowTxOutOfResourcesMap.contains(rtFbFlow);
    }

    private void updateTxTriggerResult(FbTrigger fbTrigger, RuntimeFbFlow rtFbFlow, boolean shouldSaveInterval) {
        long historySize;
        StreamResultHistory apiStreamHistory;
        Stream apiStream = rtFbFlow.getApiStream();
        if (apiStream == null) {
            StreamMobile mobile = rtFbFlow.getApiStreamMobile();
            apiStreamHistory = mobile.ResultHistoryGet();
        } else {
            apiStreamHistory = apiStream.ResultHistoryGet();
        }
        long intervalDuration = apiStreamHistory.SamplingIntervalDurationGet();
        if (fbTrigger.getSnapshotResolution() == null) {
            fbTrigger.setSnapshotResolution(intervalDuration);
        }
        if ((historySize = apiStreamHistory.CumulativeLengthGet()) > 0L) {
            this.updateOverallResults(fbTrigger, rtFbFlow.txCumulativeSnapshot());
        }
        this.updateResultsOverTime(fbTrigger, rtFbFlow.txIntervalSnapshots(), intervalDuration, shouldSaveInterval);
        this.fbTriggerManager.lightUpdate((BaseEntity)fbTrigger);
    }

    private void updateResultsOverTime(FbTrigger fbTrigger, List<LocalTriggerResultData> apiStreamHistory, long intervalDuration, boolean shouldSaveInterval) {
        int snapshotCount = apiStreamHistory.size();
        if (snapshotCount == 0) {
            return;
        }
        FbTriggerSnapshot[] snapshots = new FbTriggerSnapshot[snapshotCount];
        int historyIndex = 0;
        while (historyIndex < snapshotCount) {
            FbTriggerSnapshot newSnapshot;
            LocalTriggerResultData apiIntervalData = apiStreamHistory.get(historyIndex);
            snapshots[historyIndex] = newSnapshot = new FbTriggerSnapshot(fbTrigger, Long.valueOf(apiIntervalData.TimestampGet()), Long.valueOf(intervalDuration), Long.valueOf(apiIntervalData.PacketCountGet()), Long.valueOf(apiIntervalData.ByteCountGet()));
            fbTrigger.setLatestSnapshot(newSnapshot);
            ++historyIndex;
        }
        if (shouldSaveInterval) {
            this.fbTriggerSnapshotManager.persistIdEntity((BaseEntity[])snapshots);
        }
    }

    private void updateOverallResults(FbTrigger fbTrigger, LocalTriggerResultData cumulative) {
        fbTrigger.setByteCount(cumulative.ByteCountGet());
        long packetCount = cumulative.PacketCountGet();
        fbTrigger.setPacketCount(packetCount);
        Long firstTimestamp = null;
        Long lastTimestamp = null;
        if (packetCount > 0L) {
            firstTimestamp = cumulative.TimestampFirstGet();
            lastTimestamp = cumulative.TimestampLastGet();
        }
        fbTrigger.setFirstPacketTime(firstTimestamp);
        fbTrigger.setLastPacketTime(lastTimestamp);
    }

    private void verifyTxPacketCount(FbFlowInstance fbFlowInstance, RuntimeFbFlow rtFbFlow, FbSource fbSource) {
        boolean hasError;
        long packetsSent = fbSource.getTrigger().getPacketCount();
        long packetsToSend = rtFbFlow.getModelFlowInstanceReader().getNumberOfFrames();
        boolean hasEnd = rtFbFlow.getModelFlowInstanceReader().getDurationInNanoseconds() < Long.MAX_VALUE;
        boolean largeTxRxDifference = packetsSent > 0L && 0.02 < (double)((float)Math.abs(packetsSent - packetsToSend) / (float)Math.max(packetsSent, packetsToSend));
        boolean bl = hasError = !this.flowHasTxOutOfResourcesEvent(rtFbFlow) && largeTxRxDifference && hasEnd;
        if (fbFlowInstance.getParent() != null) {
            return;
        }
        if (!hasError) {
            return;
        }
        fbFlowInstance.setStatus(FlowInstanceStatus.ACTIVE_WARNING);
        String underFlowFormat = "Frame blasting flow '%s' did not transmit its intended load: only %d out of %d packets (%.02f %%) were sent.";
        String overFlowFormat = "Frame blasting flow '%s' unexpectedly transmitted more than its intended load: %d instead of %d packets (%.02f %%) were sent.";
        float percentDiff = packetsSent > 0L ? 100.0f * (float)packetsSent / (float)packetsToSend : Float.NaN;
        String message = packetsSent < packetsToSend ? String.format("Frame blasting flow '%s' did not transmit its intended load: only %d out of %d packets (%.02f %%) were sent.", rtFbFlow.name(), packetsSent, packetsToSend, Float.valueOf(percentDiff)) : String.format("Frame blasting flow '%s' unexpectedly transmitted more than its intended load: %d instead of %d packets (%.02f %%) were sent.", rtFbFlow.name(), packetsSent, packetsToSend, Float.valueOf(percentDiff));
        this.logFlowEvent(fbFlowInstance, message, EventSeverity.TEST_WARNING);
        this.fbFlowInstanceManager.persistIdEntity((BaseEntity)fbFlowInstance);
    }

    private void handleGlobalResults(RuntimeScenario rtScenario, boolean isScenarioFinished) {
        FbFlowInstanceReader fbFlowInstanceReader;
        FbFlowInstance fbFlowInstance;
        for (RuntimeFlow rtFlow : rtScenario.getRuntimeFlowsConfigured()) {
            if (!(rtFlow instanceof RuntimeGroupFbFlow)) continue;
            fbFlowInstance = this.getCachedFbFlowInstance(rtFlow);
            fbFlowInstanceReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
            RuntimeGroupFbFlow rtFbGroupFlow = (RuntimeGroupFbFlow)rtFlow;
            rtFbGroupFlow.visitSnapshots((RuntimeRx.SnapshotVisitor)new StoreLatencyDistribution(this.pc, rtFbGroupFlow.getRuntimeFlowDestination().toString(), fbFlowInstanceReader));
        }
        for (RuntimeFbFlow rtFbFlow : rtScenario.getRuntimeFlowsConfiguredFb()) {
            fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtFbFlow);
            fbFlowInstanceReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
            FbSource fbSource = fbFlowInstance.getSource();
            this.verifyTxPacketCount(fbFlowInstance, rtFbFlow, fbSource);
            rtFbFlow.visitSnapshots((RuntimeRx.SnapshotVisitor)new StoreLatencyDistribution(this.pc, fbFlowInstanceReader));
        }
    }

    private FbFlowInstance getCachedFbFlowInstance(RuntimeFlow rtFbFlow) {
        FbFlowInstance entity = this.fbFlowInstanceCache.get(rtFbFlow);
        return entity;
    }

    public void onFbFlowTrafficConfigured(RuntimeFbFlow rtFbFlow) {
    }

    public void onFbFlowLatencyWarning(RuntimeFbFlow rtFbFlow, RuntimeFrame frame) {
        String link;
        String message;
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtFbFlow);
        EventSeverity severity = EventSeverity.TEST_INFO;
        if (frame.hasIPv4Header()) {
            message = "IPv4 UDP Flow with Latency Measurement: automatic UDP checksum disabled.\nDue to a hardware limitation, UDP checksums of IPv4 packets in this latency flow were automatically set to zero (disabled) before timestamping. Click for more info.";
            link = IPV4_LATENCY_ARTICLE;
        } else {
            message = "IPv6 UDP Flow with Latency Measurement: automatic UDP checksum incorrect.\nDue to a hardware limitation, UDP checksums of IPv6 packets in this latency flow were incorrect after timestamping. Invalid packets may have been dropped by intermediate network devices. Click for more info.";
            link = IPV6_LATENCY_ARTICLE;
        }
        FlowInstanceEvent event = new FlowInstanceEvent(new Date(), message, severity, (FlowInstance)fbFlowInstance);
        event.setKnowledgebaseLink(link);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onFbFlowConfigurationWarning(RuntimeFbFlow rtFbFlow, String desc) {
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance((RuntimeFlow)rtFbFlow);
        EventSeverity severity = EventSeverity.TEST_WARNING;
        FlowInstanceEvent event = new FlowInstanceEvent(new Date(), desc, severity, (FlowInstance)fbFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    public void onFrameCreated(RuntimeFrame rtFrame) {
    }

    public void onFrameCreationFailed(RuntimeFrame rtFrame, String errorMessage) {
        FbFlowInstance fbFlowInstance = this.getCachedFbFlowInstance(rtFrame.getRuntimeFlow());
        EventSeverity severity = EventSeverity.TEST_WARNING;
        FlowInstanceEvent event = new FlowInstanceEvent(new Date(), errorMessage, severity, (FlowInstance)fbFlowInstance);
        this.eventManager.persistIdEntity((BaseEntity)event);
    }

    private static final class StoreLatencyDistribution
    implements RuntimeRx.SnapshotVisitor {
        private final String overridenDestination;
        private final FbFlowInstanceReader fbFlowInstanceReader;
        private BaseEntityManager<FbLatencyDistribution> fbLatencyDistributionManager;

        StoreLatencyDistribution(TestDataPersistenceController pc, FbFlowInstanceReader fbFlowInstanceReader) {
            this.fbFlowInstanceReader = fbFlowInstanceReader;
            this.fbLatencyDistributionManager = new BaseEntityManager(FbLatencyDistribution.class, pc);
            this.overridenDestination = null;
        }

        StoreLatencyDistribution(TestDataPersistenceController pc, String overridenDestination, FbFlowInstanceReader fbFlowInstanceReader) {
            this.fbFlowInstanceReader = fbFlowInstanceReader;
            this.fbLatencyDistributionManager = new BaseEntityManager(FbLatencyDistribution.class, pc);
            this.overridenDestination = overridenDestination;
        }

        public void visit(RuntimePort port, LocalLatencyResultData[] trigger) {
        }

        public void visit(RuntimePort port, LocalTriggerResultData[] trigger) {
        }

        public void visit(RuntimePort port, LocalLatencyDistributionSnapshot trigger) {
            FbDestination destination = this.overridenDestination == null ? FbFlowHandle.getDestination(port, this.fbFlowInstanceReader) : FbFlowHandle.getDestination(this.overridenDestination, this.fbFlowInstanceReader);
            long packetCount = trigger.PacketCountGet();
            FbLatency fbLatency = destination.getLatency();
            if (packetCount > 0L) {
                long rangeMinimum = trigger.RangeMinimumGet();
                long rangeMaximum = trigger.RangeMaximumGet();
                int bucketCount = trigger.BucketCountGet();
                long bucketWidth = trigger.BucketWidthGet();
                long packetCountBelowMin = trigger.PacketCountBelowMinimumGet();
                long packetCountAboveMax = trigger.PacketCountAboveMaximumGet();
                FbLatencyDistribution fbLatencyDistribution = new FbLatencyDistribution(fbLatency, rangeMinimum, rangeMaximum, bucketCount, bucketWidth, packetCountBelowMin, packetCountAboveMax);
                List bucketPacketCounts = trigger.PacketCountBucketsGet();
                long numBuckets = bucketPacketCounts.size();
                int i = 0;
                while ((long)i < numBuckets) {
                    long bucketPacketCount = (Long)bucketPacketCounts.get(i);
                    fbLatencyDistribution.addEntry(rangeMinimum + bucketWidth * (long)i, bucketPacketCount);
                    ++i;
                }
                this.fbLatencyDistributionManager.persistIdEntity((BaseEntity)fbLatencyDistribution);
            } else {
                String fmt = "The latency histogram on port ('%s') counted no packets";
                LOGGER.log(Level.INFO, String.format(fmt, port.getName()));
            }
        }

        public void visit(RuntimePort port, LocalOutOfSequenceResultData[] trigger) {
        }
    }
}

