/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.datapersistence.listeners;

import com.excentis.products.byteblower.report.json.JsonScenario;
import com.excentis.products.byteblower.run.actions.CreatePorts;
import com.excentis.products.byteblower.run.actions.RunScenario;
import com.excentis.products.byteblower.run.actions.core.Context;
import com.excentis.products.byteblower.run.objects.RuntimePort;
import com.excentis.products.byteblower.run.objects.RuntimeScenario;
import com.excentis.products.byteblower.run.utils.LocalNetworkInfoResult;
import java.util.List;
import java.util.logging.Logger;

public class GatherJsonWifiStats
implements RunScenario.Listener,
CreatePorts.Listener {
    private static Logger LOGGER = Logger.getGlobal();
    private JsonScenario scenario;

    public GatherJsonWifiStats(JsonScenario jc) {
        this.scenario = jc;
    }

    public void register(Context context) {
        context.listen(RunScenario.Listener.class, (Object)this);
        context.listen(CreatePorts.Listener.class, (Object)this);
    }

    private void collectStats(RuntimeScenario rtScenario) {
        for (RuntimePort port : rtScenario.getRuntimePorts()) {
            WiFiVisitor fetch = new WiFiVisitor(port, this.scenario);
            port.visit((RuntimePort.PortVisit)fetch);
        }
    }

    public void onPortsCreated(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunStarting(RuntimeScenario rtScenario) {
    }

    public void onScenarioRunUpdate(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunFinished(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunCancelled(RuntimeScenario rtScenario) {
        this.collectStats(rtScenario);
    }

    public void onScenarioRunFailed(RuntimeScenario rtScenario, String errorMessage) {
        this.collectStats(rtScenario);
    }

    private static final class WiFiVisitor
    implements RuntimePort.PortVisit {
        private final RuntimePort port;
        private final JsonScenario scenario;

        private WiFiVisitor(RuntimePort port, JsonScenario scenario) {
            this.port = port;
            this.scenario = scenario;
        }

        private String humanInterfaceName(LocalNetworkInfoResult.LocalNetworkInterface netIf) {
            int max_length = 128;
            String ifName = netIf.name;
            return ifName.substring(0, Math.min(ifName.length(), 128));
        }

        public void visitWifi(List<LocalNetworkInfoResult> results) {
            String portName = this.port.getName();
            boolean hasRealtimeWiFiResults = false;
            for (LocalNetworkInfoResult result : results) {
                long timestamp = result.TimestampGet();
                if (result.InterfaceGet().size() == 0) {
                    LOGGER.warning(String.format("- Snapshot %d does not have any interfaces!", (int)((double)result.TimestampGet() / 1.0E9)));
                }
                for (LocalNetworkInfoResult.LocalNetworkInterface netIf : result.InterfaceGet()) {
                    if (netIf.type != LocalNetworkInfoResult.NetIfType.WiFi) continue;
                    if (!result.untimedResults()) {
                        String ifName = this.humanInterfaceName(netIf);
                        this.scenario.addWifiSample(portName, ifName, timestamp, netIf.rssi, netIf.bssid, netIf.ssid);
                    }
                    boolean bl = hasRealtimeWiFiResults = hasRealtimeWiFiResults || !netIf.ssid.isEmpty();
                }
            }
        }
    }
}

